/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.earth.transformation;

import com.derletztekick.geodesy.earth.point.PointXYZ;

public class Helmert3D {
    private double tx = 0.0;
    private double ty = 0.0;
    private double tz = 0.0;
    private double rx = 0.0;
    private double ry = 0.0;
    private double rz = 0.0;
    private double m = 1.0;

    public Helmert3D() {
    }

    public Helmert3D(double[] params) {
        this(params[0], params[1], params[2], params[3], params[4], params[5], params[6]);
    }

    public Helmert3D(double tx, double ty, double tz, double m, double rx, double ry, double rz) {
        this.tx = tx;
        this.ty = ty;
        this.tz = tz;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
        this.m = m;
    }

    public double[] getTransformationParameter() {
        return new double[]{this.tx, this.ty, this.tz, this.m, this.rx, this.ry, this.rz};
    }

    public PointXYZ transform(PointXYZ point) {
        return Helmert3D.transform(point, this.tx, this.ty, this.tz, this.m, this.rx, this.ry, this.rz);
    }

    public PointXYZ invTransform(PointXYZ point) {
        return Helmert3D.invTransform(point, this.tx, this.ty, this.tz, this.m, this.rx, this.ry, this.rz);
    }

    public static PointXYZ invTransform(PointXYZ point, double tx, double ty, double tz, double m, double rx, double ry, double rz) {
        double x = point.getX() - tx;
        double y = point.getY() - ty;
        double z = point.getZ() - tz;
        double[][] R = new double[][]{{Math.cos(ry) * Math.cos(rz), -Math.cos(ry) * Math.sin(rz), Math.sin(ry)}, {Math.cos(rx) * Math.sin(rz) + Math.sin(rx) * Math.sin(ry) * Math.cos(rz), Math.cos(rx) * Math.cos(rz) - Math.sin(rx) * Math.sin(ry) * Math.sin(rz), -Math.sin(rx) * Math.cos(ry)}, {Math.sin(rx) * Math.sin(rz) - Math.cos(rx) * Math.sin(ry) * Math.cos(rz), Math.sin(rx) * Math.cos(rz) + Math.cos(rx) * Math.sin(ry) * Math.sin(rz), Math.cos(rx) * Math.cos(ry)}};
        double r11 = R[0][0];
        double r12 = R[0][1];
        double r13 = R[0][2];
        double r21 = R[1][0];
        double r22 = R[1][1];
        double r23 = R[1][2];
        double r31 = R[2][0];
        double r32 = R[2][1];
        double r33 = R[2][2];
        return new PointXYZ((r11 * x + r12 * y + r13 * z) / m, (r21 * x + r22 * y + r23 * z) / m, (r31 * x + r32 * y + r33 * z) / m);
    }

    public static PointXYZ transform(PointXYZ point, double tx, double ty, double tz, double m, double rx, double ry, double rz) {
        double x = point.getX();
        double y = point.getY();
        double z = point.getZ();
        double[][] R = new double[][]{{Math.cos(ry) * Math.cos(rz), Math.cos(rx) * Math.sin(rz) + Math.sin(rx) * Math.sin(ry) * Math.cos(rz), Math.sin(rx) * Math.sin(rz) - Math.cos(rx) * Math.sin(ry) * Math.cos(rz)}, {-Math.cos(ry) * Math.sin(rz), Math.cos(rx) * Math.cos(rz) - Math.sin(rx) * Math.sin(ry) * Math.sin(rz), Math.sin(rx) * Math.cos(rz) + Math.cos(rx) * Math.sin(ry) * Math.sin(rz)}, {Math.sin(ry), -Math.sin(rx) * Math.cos(ry), Math.cos(rx) * Math.cos(ry)}};
        double r11 = R[0][0];
        double r12 = R[0][1];
        double r13 = R[0][2];
        double r21 = R[1][0];
        double r22 = R[1][1];
        double r23 = R[1][2];
        double r31 = R[2][0];
        double r32 = R[2][1];
        double r33 = R[2][2];
        return new PointXYZ(tx + m * (r11 * x + r12 * y + r13 * z), ty + m * (r21 * x + r22 * y + r23 * z), tz + m * (r31 * x + r32 * y + r33 * z));
    }

    public static void main(String[] args) {
        double tx = 598.1;
        double ty = 73.7;
        double tz = 418.2;
        double rx = 9.793236358412627E-7;
        double ry = 2.1816615649929117E-7;
        double rz = -1.1902175871239108E-5;
        double m = 1.0000067;
        PointXYZ pXYZ = new PointXYZ(3846209.902, 547352.344, 5041721.149);
        Helmert3D helmert3d = new Helmert3D(tx, ty, tz, m, rx, ry, rz);
        PointXYZ pxyz = helmert3d.transform(pXYZ);
        System.out.println(pXYZ);
        System.out.println(pxyz);
        pXYZ = helmert3d.invTransform(pxyz);
        System.out.println(pXYZ);
        System.out.println();
        pXYZ = new PointXYZ(3846209.902, 547352.344, 5041721.149);
        pxyz = Helmert3D.transform(pXYZ, tx, ty, tz, m, rx, ry, rz);
        System.out.println(pXYZ);
        System.out.println(pxyz);
        pXYZ = Helmert3D.invTransform(pxyz, tx, ty, tz, m, rx, ry, rz);
        System.out.println(pXYZ);
        pXYZ = new PointXYZ(3846209.902, 547352.344, 5041721.149);
    }
}

