/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.earth.transformation;

import com.derletztekick.geodesy.earth.projection.point.PointENH;
import com.derletztekick.geodesy.earth.transformation.Transformation2D;
import java.util.Arrays;

public class Helmert2D
extends Transformation2D {
    public Helmert2D() {
    }

    public Helmert2D(double[] params) {
        this(params[0], params[1], params[2], params[3]);
    }

    public Helmert2D(double tx, double ty, double a, double o) {
        super(tx, ty, a, o, a, o);
    }

    @Override
    public double[] estimateParameters(PointENH[] src, PointENH[] trg) {
        double nop = src.length;
        if (nop <= 0.0 || nop != (double)trg.length) {
            return null;
        }
        double xs = 0.0;
        double ys = 0.0;
        double xt = 0.0;
        double yt = 0.0;
        int i = 0;
        while ((double)i < nop) {
            xs += src[i].getX();
            ys += src[i].getY();
            xt += trg[i].getX();
            yt += trg[i].getY();
            ++i;
        }
        xs /= nop;
        ys /= nop;
        xt /= nop;
        yt /= nop;
        double o = 0.0;
        double a = 0.0;
        double oa = 0.0;
        int i2 = 0;
        while ((double)i2 < nop) {
            double x = src[i2].getX() - xs;
            double y = src[i2].getY() - ys;
            double X = trg[i2].getX() - xt;
            double Y = trg[i2].getY() - yt;
            o += x * Y - y * X;
            a += x * X + y * Y;
            oa += x * x + y * y;
            ++i2;
        }
        double tx = xt - (a /= oa) * xs + (o /= oa) * ys;
        double ty = yt - a * ys - o * xs;
        this.setTransformationParameter(tx, ty, a, o, a, o);
        return this.getTransformationParameter();
    }

    public static void main(String[] args) {
        PointENH[] src = new PointENH[]{new PointENH(2508000.0, 5546000.0, 0.0), new PointENH(2508000.0, 5547000.0, 0.0), new PointENH(2509000.0, 5546000.0, 0.0), new PointENH(2509000.0, 5547000.0, 0.0)};
        PointENH[] trg = new PointENH[]{new PointENH(3.2293190462E7, 5548212.416, 0.0), new PointENH(3.2293230621E7, 5549211.738, 0.0), new PointENH(3.2294189786E7, 5548172.266, 0.0), new PointENH(3.2294229944E7, 5549171.581, 0.0)};
        Helmert2D affin = new Helmert2D();
        double[] param = affin.estimateParameters(src, trg);
        System.out.println(Arrays.toString(param));
        int i = 0;
        while (i < src.length) {
            System.out.println(Helmert2D.invTransform(Helmert2D.transform(src[i], param[0], param[1], param[2], param[3], param[4], param[5]), param[0], param[1], param[2], param[3], param[4], param[5]));
            ++i;
        }
        System.out.println("--");
        System.out.println(affin.transform(new PointENH(2508150.0, 5546951.0, 0.0)));
        System.out.println(affin.transformAndInverseDistanceWeighting(src, trg, new PointENH(2508150.0, 5546951.0, 0.0), 0.0, 0.0));
        System.out.println(affin.transformAndInverseDistanceWeighting(src, trg, new PointENH(2508150.0, 5546951.0, 0.0), 0.0, 2.0));
    }
}

