/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.earth.transformation;

import com.derletztekick.geodesy.earth.projection.point.PointENH;
import com.derletztekick.geodesy.earth.transformation.Transformation2D;
import java.util.Arrays;

public class Affin2D
extends Transformation2D {
    public Affin2D() {
    }

    public Affin2D(double[] params) {
        this(params[0], params[1], params[2], params[3], params[4], params[5]);
    }

    public Affin2D(double tx, double ty, double a11, double a12, double a22, double a21) {
        super(tx, ty, a11, a12, a22, a21);
    }

    @Override
    public double[] estimateParameters(PointENH[] src, PointENH[] trg) {
        double nop = src.length;
        if (nop <= 0.0 || nop != (double)trg.length) {
            return null;
        }
        double xs = 0.0;
        double ys = 0.0;
        double xt = 0.0;
        double yt = 0.0;
        int i = 0;
        while ((double)i < nop) {
            xs += src[i].getX();
            ys += src[i].getY();
            xt += trg[i].getX();
            yt += trg[i].getY();
            ++i;
        }
        xs /= nop;
        ys /= nop;
        xt /= nop;
        yt /= nop;
        double xX = 0.0;
        double yy = 0.0;
        double yX = 0.0;
        double xy = 0.0;
        double xx = 0.0;
        double xY = 0.0;
        double yY = 0.0;
        int i2 = 0;
        while ((double)i2 < nop) {
            double x = src[i2].getX() - xs;
            double y = src[i2].getY() - ys;
            double X = trg[i2].getX() - xt;
            double Y = trg[i2].getY() - yt;
            xx += x * x;
            xX += x * X;
            xY += x * Y;
            yy += y * y;
            yX += y * X;
            xy += x * y;
            yY += y * Y;
            ++i2;
        }
        double n = xx * yy - xy * xy;
        double a11 = (xX * yy - yX * xy) / n;
        double a12 = (xX * xy - yX * xx) / n;
        double a22 = (yY * xx - xY * xy) / n;
        double a21 = (xY * yy - yY * xy) / n;
        double tx = xt - a11 * xs + a12 * ys;
        double ty = yt - a22 * ys - a21 * xs;
        this.setTransformationParameter(tx, ty, a11, a12, a22, a21);
        return this.getTransformationParameter();
    }

    public static void main(String[] args) {
        PointENH[] src = new PointENH[]{new PointENH(2508000.0, 5546000.0, 0.0), new PointENH(2508000.0, 5547000.0, 0.0), new PointENH(2509000.0, 5546000.0, 0.0), new PointENH(2509000.0, 5547000.0, 0.0)};
        PointENH[] trg = new PointENH[]{new PointENH(3.2293190462E7, 5548212.416, 0.0), new PointENH(3.2293230621E7, 5549211.738, 0.0), new PointENH(3.2294189786E7, 5548172.266, 0.0), new PointENH(3.2294229944E7, 5549171.581, 0.0)};
        Affin2D affin = new Affin2D();
        double[] param = affin.estimateParameters(src, trg);
        System.out.println(Arrays.toString(param));
        int i = 0;
        while (i < src.length) {
            System.out.println(Affin2D.invTransform(Affin2D.transform(src[i], param[0], param[1], param[2], param[3], param[4], param[5]), param[0], param[1], param[2], param[3], param[4], param[5]));
            ++i;
        }
        System.out.println("--");
        System.out.println(affin.transform(new PointENH(2508150.0, 5546951.0, 0.0)));
        System.out.println(affin.transformAndInverseDistanceWeighting(src, trg, new PointENH(2508150.0, 5546951.0, 0.0), 0.0, 0.0));
        System.out.println(affin.transformAndInverseDistanceWeighting(src, trg, new PointENH(2508150.0, 5546951.0, 0.0), 0.0, 2.0));
    }
}

