/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.earth.projection;

public enum ProjectionType {
    GK_3("GK-3\u00b0"),
    GK_6("GK-6\u00b0"),
    UTM_N("UTM (N)"),
    UTM_S("UTM (S)"),
    SOLDNER("Soldner"),
    MGI_M28("GK-3\u00b0 [M28]"),
    MGI_M31("GK-3\u00b0 [M31]"),
    MGI_M34("GK-3\u00b0 [M34]"),
    MGI_DKSBiH_GK("GK-3\u00b0 [s = 0.9999]"),
    MGI_DKSBiH_UTM("UTM [s = 0.9999]");

    private String label = "";

    private ProjectionType(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isNorthernHemisphere() {
        return this != UTM_S;
    }

    public final int getZoneWidth() {
        if (this == GK_3 || this == MGI_DKSBiH_GK) {
            return 3;
        }
        return 6;
    }

    public String toString() {
        return this.label;
    }
}

