/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.earth.projection;

import com.derletztekick.geodesy.earth.ellipsoid.Ellipsoid;
import com.derletztekick.geodesy.earth.projection.ProjectionType;
import com.derletztekick.geodesy.earth.projection.point.PointENH;
import com.derletztekick.geodesy.earth.projection.point.PointLatLonH;
import com.derletztekick.tools.geodesy.Complex;
import com.derletztekick.tools.geodesy.Constant;

public class MapProjection {
    private final double EPS = Math.pow(Constant.EPS, 0.85);
    private final Ellipsoid ellipsoid;
    private final ProjectionType projectionType;
    private final int MAX_ITER = 30;
    private final double[] dn;
    private final double[] kn;
    private boolean useApproximation = true;

    public MapProjection(Ellipsoid ellipsoid, ProjectionType type) {
        this(ellipsoid, type, true);
    }

    public MapProjection(Ellipsoid ellipsoid, ProjectionType type, boolean useApproximation) {
        this.ellipsoid = ellipsoid;
        this.projectionType = type;
        this.useApproximation = useApproximation;
        this.dn = this.getD(31, this.ellipsoid.getE1Square());
        this.kn = this.getK(31);
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public PointENH LatLon2EastNorth(PointLatLonH pointBL) {
        return switch (this.projectionType) {
            case ProjectionType.GK_3, ProjectionType.GK_6, ProjectionType.MGI_M28, ProjectionType.MGI_M31, ProjectionType.MGI_M34, ProjectionType.MGI_DKSBiH_GK -> this.GK_BL2XY(pointBL);
            case ProjectionType.SOLDNER -> this.Soldner_BL2XY(pointBL, 0.0, 0.0);
            default -> this.UTM_BL2XY(pointBL);
        };
    }

    public PointENH LatLon2EastNorth(PointLatLonH pointBL, double lamda0) {
        return switch (this.projectionType) {
            case ProjectionType.GK_3, ProjectionType.GK_6, ProjectionType.MGI_M28, ProjectionType.MGI_M31, ProjectionType.MGI_M34, ProjectionType.MGI_DKSBiH_GK -> this.GK_BL2XY(pointBL, lamda0);
            case ProjectionType.SOLDNER -> this.Soldner_BL2XY(pointBL, lamda0, 0.0);
            default -> this.UTM_BL2XY(pointBL, lamda0);
        };
    }

    public PointENH LatLon2EastNorth(PointLatLonH pointBL, double lamda0, double phi0) {
        return switch (this.projectionType) {
            case ProjectionType.GK_3, ProjectionType.GK_6, ProjectionType.MGI_M28, ProjectionType.MGI_M31, ProjectionType.MGI_M34, ProjectionType.MGI_DKSBiH_GK -> this.GK_BL2XY(pointBL, lamda0);
            case ProjectionType.SOLDNER -> this.Soldner_BL2XY(pointBL, lamda0, phi0);
            default -> this.UTM_BL2XY(pointBL, lamda0);
        };
    }

    public PointLatLonH EastNorth2LatLon(PointENH pointYX) {
        return switch (this.projectionType) {
            case ProjectionType.GK_3, ProjectionType.GK_6, ProjectionType.MGI_M28, ProjectionType.MGI_M31, ProjectionType.MGI_M34, ProjectionType.MGI_DKSBiH_GK -> this.GK_XY2BL(pointYX);
            case ProjectionType.SOLDNER -> this.Soldner_XY2BL(pointYX, 0.0, 0.0);
            default -> this.UTM_XY2BL(pointYX, this.projectionType.isNorthernHemisphere());
        };
    }

    public PointLatLonH EastNorth2LatLon(PointENH pointYX, double lamda0) {
        return switch (this.projectionType) {
            case ProjectionType.GK_3, ProjectionType.GK_6, ProjectionType.MGI_M28, ProjectionType.MGI_M31, ProjectionType.MGI_M34, ProjectionType.MGI_DKSBiH_GK -> this.GK_XY2BL(pointYX, lamda0);
            case ProjectionType.SOLDNER -> this.Soldner_XY2BL(pointYX, lamda0, 0.0);
            default -> this.UTM_XY2BL(pointYX, lamda0, this.projectionType.isNorthernHemisphere());
        };
    }

    public PointLatLonH EastNorth2LatLon(PointENH pointYX, double lamda0, double phi0) {
        return switch (this.projectionType) {
            case ProjectionType.GK_3, ProjectionType.GK_6, ProjectionType.MGI_M28, ProjectionType.MGI_M31, ProjectionType.MGI_M34, ProjectionType.MGI_DKSBiH_GK -> this.GK_XY2BL(pointYX, lamda0);
            case ProjectionType.SOLDNER -> this.Soldner_XY2BL(pointYX, lamda0, phi0);
            default -> this.UTM_XY2BL(pointYX, lamda0, this.projectionType.isNorthernHemisphere());
        };
    }

    private int getUTMZone(double lambda) {
        return (int)((lambda * 57.29577951308232 + 180.0) / (double)this.projectionType.getZoneWidth()) + 1;
    }

    private double getUTMCentralMeridian(int zone) {
        return (-183.0 + (double)(zone * this.projectionType.getZoneWidth())) * (Math.PI / 180);
    }

    private double getGKCentralMeridian(int kz) {
        return (double)(kz * this.projectionType.getZoneWidth() - (this.projectionType == ProjectionType.GK_3 || this.projectionType == ProjectionType.MGI_DKSBiH_GK ? 0 : 3)) * (Math.PI / 180);
    }

    private PointLatLonH UTM_XY2BL(PointENH point, boolean isNorthernHemisphere) {
        return this.UTM_XY2BL(point, switch (this.projectionType) {
            case ProjectionType.MGI_DKSBiH_UTM -> 0.3141592653589793;
            default -> {
                int zone = (int)(point.getY() / 1000000.0);
                yield this.getUTMCentralMeridian(zone);
            }
        }, isNorthernHemisphere);
    }

    private PointLatLonH UTM_XY2BL(PointENH point, double lambda0, boolean isNorthernHemisphere) {
        double x0;
        double scale;
        double y = point.getY();
        double x = point.getX();
        PointLatLonH pointBL = this.YX2BL((switch (this.projectionType) {
            case ProjectionType.MGI_DKSBiH_UTM -> {
                scale = 0.9999;
                x0 = x;
                yield y - 500000.0;
            }
            default -> {
                scale = 0.9996;
                x0 = point.getX() - (isNorthernHemisphere ? 0.0 : 1.0E7);
                int kz = (int)(y / 1000000.0);
                yield y - 500000.0 - 1000000.0 * (double)kz;
            }
        }) / scale, x0 / scale);
        return new PointLatLonH(pointBL.getLatitude(), lambda0 + pointBL.getLongitude(), point.getHeight());
    }

    private PointLatLonH GK_XY2BL(PointENH point, double lambda0) {
        double y0;
        double scale = this.projectionType == ProjectionType.MGI_DKSBiH_GK ? 0.9999 : 1.0;
        double y = point.getY();
        double x = point.getX();
        PointLatLonH pointBL = this.YX2BL(y0 / scale, (switch (this.projectionType) {
            case ProjectionType.MGI_M28, ProjectionType.MGI_M31, ProjectionType.MGI_M34 -> {
                y0 = y;
                yield 5000000.0 + x;
            }
            default -> {
                int kz = (int)(y / 1000000.0);
                y0 = y - 500000.0 - 1000000.0 * (double)kz;
                yield x;
            }
        }) / scale);
        return new PointLatLonH(pointBL.getLatitude(), lambda0 + pointBL.getLongitude(), point.getHeight());
    }

    private PointLatLonH GK_XY2BL(PointENH PointENH2) {
        return this.GK_XY2BL(PointENH2, switch (this.projectionType) {
            case ProjectionType.MGI_M28 -> 0.1803506893727474;
            case ProjectionType.MGI_M31 -> 0.23271056693257727;
            case ProjectionType.MGI_M34 -> 0.28507044449240715;
            default -> {
                int kz = (int)(PointENH2.getY() / 1000000.0);
                yield this.getGKCentralMeridian(kz);
            }
        });
    }

    private PointLatLonH Soldner_XY2BL(PointENH PointENH2, double lambda0, double phi0) {
        double x = PointENH2.getX();
        double y = PointENH2.getY();
        double a = this.ellipsoid.getMajorAxis();
        double b = this.ellipsoid.getMinorAxis();
        double e2 = this.ellipsoid.getE2Square();
        double phiF = this.ellipsoid.getLatitudeFromMeridianArcLength(x + this.ellipsoid.getMeridianArcLengthFromLatitude(phi0));
        double etaF2 = e2 * Math.cos(phiF) * Math.cos(phiF);
        double tF = Math.tan(phiF);
        double tF2 = tF * tF;
        double Nf = a * a / (b * Math.sqrt(1.0 + etaF2));
        double Nf2 = Nf * Nf;
        double phi = phiF + tF / (2.0 * Nf2) * (-1.0 - etaF2) * y * y;
        double dlambda = y / (Nf * Math.cos(phiF));
        dlambda += -tF2 / (3.0 * Nf * Nf2 * Math.cos(phiF)) * y * y * y;
        return new PointLatLonH(phi += tF / (24.0 * Nf2 * Nf2) * (1.0 + 3.0 * tF2 + 2.0 * etaF2 - 6.0 * tF2 * etaF2) * y * y * y * y, lambda0 + (dlambda += Math.pow(y, 5.0) / (15.0 * Nf * Nf2 * Nf2 * Math.cos(phiF)) * (tF2 + 3.0 * tF2 * tF2)), PointENH2.getHeight());
    }

    private PointENH UTM_BL2XY(PointLatLonH PointLatLonH2) {
        double lambda = PointLatLonH2.getLongitude();
        return this.UTM_BL2XY(PointLatLonH2, switch (this.projectionType) {
            case ProjectionType.MGI_DKSBiH_UTM -> 0.3141592653589793;
            default -> {
                int zone = this.getUTMZone(lambda);
                yield this.getUTMCentralMeridian(zone);
            }
        });
    }

    private PointENH UTM_BL2XY(PointLatLonH PointLatLonH2, double lambda0) {
        double scale = this.projectionType == ProjectionType.MGI_DKSBiH_UTM ? 0.9999 : 0.9996;
        double phi = PointLatLonH2.getLatitude();
        double lambda = PointLatLonH2.getLongitude();
        double dLambda = lambda - lambda0;
        int zone = switch (this.projectionType) {
            case ProjectionType.MGI_DKSBiH_UTM -> 0;
            default -> this.getUTMZone(lambda0);
        };
        PointENH pointYX = this.BL2YX(phi, dLambda);
        double utmNorth = scale * pointYX.getX() + (pointYX.getX() < 0.0 ? 1.0E7 : 0.0);
        double utmEast = scale * pointYX.getY() + 500000.0 + (double)zone * 1000000.0;
        return new PointENH(utmEast, utmNorth, PointLatLonH2.getHeight());
    }

    private PointENH Soldner_BL2XY(PointLatLonH point, double lambda0, double phi0) {
        double phi = point.getLatitude();
        double lambda = point.getLongitude();
        double dLambda = lambda - lambda0;
        double a = this.ellipsoid.getMajorAxis();
        double b = this.ellipsoid.getMinorAxis();
        double e2 = this.ellipsoid.getE2Square();
        double B0 = this.ellipsoid.getMeridianArcLengthFromLatitude(phi0);
        double B = this.ellipsoid.getMeridianArcLengthFromLatitude(phi);
        double eta2 = e2 * Math.cos(phi) * Math.cos(phi);
        double t = Math.tan(phi);
        double t2 = t * t;
        double N = a * a / (b * Math.sqrt(1.0 + eta2));
        double x = B - B0 + 0.5 * N * Math.pow(Math.cos(phi), 2.0) * t * Math.pow(dLambda, 2.0) + 0.041666666666666664 * N * Math.pow(Math.cos(phi), 4.0) * t * (5.0 - t2 + 5.0 * eta2) * Math.pow(dLambda, 4.0);
        double y = N * Math.cos(phi) * dLambda - 0.16666666666666666 * N * Math.pow(Math.cos(phi), 3.0) * t2 * Math.pow(dLambda, 3.0) + 0.008333333333333333 * N * Math.pow(Math.cos(phi), 5.0) * (-8.0 * t2 + t2 * t2) * Math.pow(dLambda, 5.0);
        return new PointENH(y, x, point.getHeight());
    }

    private PointENH GK_BL2XY(PointLatLonH point, double lambda0) {
        double phi = point.getLatitude();
        double lambda = point.getLongitude();
        double dLambda = lambda - lambda0;
        PointENH pointYX = this.BL2YX(phi, dLambda);
        double scale = this.projectionType == ProjectionType.MGI_DKSBiH_GK ? 0.9999 : 1.0;
        switch (this.projectionType) {
            case MGI_M28: 
            case MGI_M31: 
            case MGI_M34: {
                return new PointENH(pointYX.getY(), pointYX.getX() - 5000000.0, point.getHeight());
            }
        }
        int kz = (int)Math.round((lambda0 * 57.29577951308232 + (double)(this.projectionType == ProjectionType.GK_3 || this.projectionType == ProjectionType.MGI_DKSBiH_GK ? 0 : 3)) / (double)this.projectionType.getZoneWidth());
        double gkNorth = scale * pointYX.getX();
        double gkEast = scale * pointYX.getY() + 500000.0 + (double)kz * 1000000.0;
        return new PointENH(gkEast, gkNorth, point.getHeight());
    }

    private PointENH GK_BL2XY(PointLatLonH point) {
        double lambda = point.getLongitude();
        return this.GK_BL2XY(point, switch (this.projectionType) {
            case ProjectionType.MGI_M28 -> 0.1803506893727474;
            case ProjectionType.MGI_M31 -> 0.23271056693257727;
            case ProjectionType.MGI_M34 -> 0.28507044449240715;
            default -> {
                int kz = (int)((lambda * 57.29577951308232 + (this.projectionType == ProjectionType.GK_3 || this.projectionType == ProjectionType.MGI_DKSBiH_GK ? 0.5 : 1.0) * (double)this.projectionType.getZoneWidth()) / (double)this.projectionType.getZoneWidth());
                yield this.getGKCentralMeridian(kz);
            }
        });
    }

    private double arth(double n) {
        return 0.5 * Math.log((1.0 + n) / (1.0 - n));
    }

    private Complex arth(Complex n) {
        Complex e = Complex.ONE;
        return e.plus(n).divides(e.minus(n)).log().times(0.5);
    }

    private double[] getD(int n, double e2) {
        double[] d = new double[n];
        d[0] = 1.0;
        int i = 1;
        while (i < n) {
            double temp = 2.0 * ((double)i - 1.0);
            d[i] = d[i - 1] * ((temp + 1.0) * (temp + 3.0)) / (temp + 2.0) / (temp + 2.0) * e2;
            ++i;
        }
        return d;
    }

    private double[] getK(int n) {
        double[] k = new double[n];
        k[0] = 1.0;
        int i = 1;
        while (i < n) {
            double temp = 2.0 * ((double)i - 1.0);
            k[i] = k[i - 1] * (temp + 2.0) / (temp + 3.0);
            ++i;
        }
        return k;
    }

    private PointENH strictBL2YX(double phi, double dLambda) {
        double a = this.ellipsoid.getMajorAxis();
        double e1 = this.ellipsoid.getE1Square();
        double sqrtE1 = Math.sqrt(e1);
        double M0 = a * (1.0 - e1);
        Complex wi = new Complex(this.arth(Math.sin(phi)) - sqrtE1 * this.arth(sqrtE1 * Math.sin(phi)), dLambda);
        Complex bi = wi.tanh().asin();
        int i = 0;
        double x = 0.0;
        double y = 0.0;
        boolean foundSolution = false;
        while (i++ < 30 && !foundSolution) {
            double Di = 0.0;
            Complex Ei = Complex.ZERO;
            int k = 1;
            while (k <= i) {
                double dk = this.dn[k];
                Di += dk;
                Complex kk = Complex.ZERO;
                int l = 0;
                while (l <= k - 1) {
                    kk = kk.plus(bi.sin().pow(2.0 * (double)l).times(this.kn[l]));
                    ++l;
                }
                Ei = Ei.plus(kk.times(dk));
                ++k;
            }
            bi = wi.plus(this.arth(bi.sin().times(sqrtE1)).times(sqrtE1)).tanh().asin();
            Complex z = bi.times(M0 * (1.0 + Di)).minus(Ei.times(bi.times(2.0).sin()).times(0.5 * M0));
            double xi = z.real();
            double yi = z.image();
            foundSolution = Math.abs(x - xi) < this.EPS && Math.abs(y - yi) < this.EPS;
            x = xi;
            y = yi;
        }
        return new PointENH(y, x, 0.0);
    }

    private PointLatLonH YX2BL(double y, double x) {
        return this.useApproximation ? this.approximatedYX2BL(y, x) : this.strictYX2BL(y, x);
    }

    private PointENH BL2YX(double phi, double dLambda) {
        return this.useApproximation ? this.approximatedBL2YX(phi, dLambda) : this.strictBL2YX(phi, dLambda);
    }

    private PointLatLonH strictYX2BL(double y, double x) {
        double a = this.ellipsoid.getMajorAxis();
        double e1 = this.ellipsoid.getE1Square();
        double sqrtE1 = Math.sqrt(e1);
        double M0 = a * (1.0 - e1);
        Complex zi = new Complex(x, y);
        Complex bi = zi.divides(M0);
        double re = Double.MAX_VALUE;
        double im = Double.MAX_VALUE;
        int i = 0;
        boolean foundSolution = false;
        while (i++ < 30 && !foundSolution) {
            double Di = 0.0;
            Complex Ei = Complex.ZERO;
            int k = 1;
            while (k <= i) {
                double dk = this.dn[k];
                Di += dk;
                Complex kk = Complex.ZERO;
                int l = 0;
                while (l <= k - 1) {
                    kk = kk.plus(bi.sin().pow(2.0 * (double)l).times(this.kn[l]));
                    ++l;
                }
                Ei = Ei.plus(kk.times(dk));
                ++k;
            }
            bi = zi.divides(M0 * (1.0 + Di)).plus(bi.times(2.0).sin().times(Ei.divides(2.0 * (1.0 + Di))));
            Complex wi = this.arth(bi.sin()).minus(this.arth(bi.sin().times(sqrtE1)).times(sqrtE1));
            double rei = wi.real();
            double imi = wi.image();
            foundSolution = Math.abs(re - rei) < this.EPS && Math.abs(im - imi) < this.EPS;
            re = rei;
            im = imi;
        }
        double phi = re;
        double lambda = im;
        double phi0 = phi;
        foundSolution = false;
        i = 0;
        while (i++ < 30 && !foundSolution) {
            double phii = Math.asin(Math.tanh(phi0 + sqrtE1 * this.arth(sqrtE1 * Math.sin(phi))));
            foundSolution = Math.abs(phi - phii) < this.EPS;
            phi = phii;
        }
        return new PointLatLonH(phi, lambda, 0.0);
    }

    private PointENH approximatedBL2YX(double phi, double dLambda) {
        double a = this.ellipsoid.getMajorAxis();
        double b = this.ellipsoid.getMinorAxis();
        double e2 = this.ellipsoid.getE2Square();
        double Bphi = this.ellipsoid.getMeridianArcLengthFromLatitude(phi);
        double eta2 = e2 * Math.cos(phi) * Math.cos(phi);
        double t = Math.tan(phi);
        double t2 = t * t;
        double N = a * a / (b * Math.sqrt(1.0 + eta2));
        double x = Bphi + t / 2.0 * N * Math.pow(Math.cos(phi), 2.0) * Math.pow(dLambda, 2.0) + t / 24.0 * N * Math.pow(Math.cos(phi), 4.0) * (5.0 - t2 + 9.0 * eta2 + 4.0 * eta2 * eta2) * Math.pow(dLambda, 4.0) + t / 720.0 * N * Math.pow(Math.cos(phi), 6.0) * (61.0 - 58.0 * t2 + t2 * t2 + 270.0 * eta2 - 330.0 * t2 * eta2) * Math.pow(dLambda, 6.0) + t / 40320.0 * N * Math.pow(Math.cos(phi), 8.0) * (1385.0 - 3111.0 * t2 + 543.0 * t2 * t2 - Math.pow(t, 6.0)) * Math.pow(dLambda, 8.0);
        double y = N * Math.cos(phi) * dLambda + 0.16666666666666666 * N * Math.pow(Math.cos(phi), 3.0) * (1.0 - t2 + eta2) * Math.pow(dLambda, 3.0) + 0.008333333333333333 * N * Math.pow(Math.cos(phi), 5.0) * (5.0 - 18.0 * t2 + t2 * t2 + 14.0 * eta2 - 58.0 * t2 * eta2) * Math.pow(dLambda, 5.0) + 1.984126984126984E-4 * N * Math.pow(Math.cos(phi), 7.0) * (61.0 - 479.0 * t2 + 179.0 * t2 * t2 - Math.pow(t, 6.0)) * Math.pow(dLambda, 7.0);
        return new PointENH(y, x, 0.0);
    }

    private PointLatLonH approximatedYX2BL(double y, double x) {
        double a = this.ellipsoid.getMajorAxis();
        double b = this.ellipsoid.getMinorAxis();
        double e2 = this.ellipsoid.getE2Square();
        double phiF = this.ellipsoid.getLatitudeFromMeridianArcLength(x);
        double etaF2 = e2 * Math.cos(phiF) * Math.cos(phiF);
        double tF = Math.tan(phiF);
        double tF2 = tF * tF;
        double Nf = a * a / (b * Math.sqrt(1.0 + etaF2));
        double phi = phiF + tF / (2.0 * Math.pow(Nf, 2.0)) * (-1.0 - etaF2) * y * y + tF / (24.0 * Math.pow(Nf, 4.0)) * (5.0 + 3.0 * tF2 + 6.0 * etaF2 - 6.0 * tF2 * etaF2 - 3.0 * etaF2 * etaF2 - 9.0 * tF2 * etaF2 * etaF2) * Math.pow(y, 4.0) + tF / (720.0 * Math.pow(Nf, 6.0)) * (-61.0 - 90.0 * tF2 - 45.0 * tF2 * tF2 - 107.0 * etaF2 + 162.0 * tF2 * etaF2 + 45.0 * tF2 * tF2 * etaF2) * Math.pow(y, 6.0) + tF / (40320.0 * Math.pow(Nf, 8.0)) * (1385.0 + 3633.0 * tF2 + 4095.0 * tF2 * tF2 + 1575.0 * Math.pow(tF, 6.0)) * Math.pow(y, 8.0);
        double lambda = 1.0 / (Nf * Math.cos(phiF)) * y + 1.0 / (6.0 * Math.pow(Nf, 3.0) * Math.cos(phiF)) * (-1.0 - 2.0 * tF2 - etaF2) * Math.pow(y, 3.0) + 1.0 / (120.0 * Math.pow(Nf, 5.0) * Math.cos(phiF)) * (5.0 + 28.0 * tF2 + 24.0 * tF2 * tF2 + 6.0 * etaF2 + 8.0 * tF2 * etaF2) * Math.pow(y, 5.0) + 1.0 / (5040.0 * Math.pow(Nf, 7.0) * Math.cos(phiF)) * (-61.0 - 662.0 * tF2 - 1320.0 * tF2 * tF2 - 720.0 * Math.pow(tF, 6.0)) * Math.pow(y, 7.0);
        return new PointLatLonH(phi, lambda, 0.0);
    }

    public boolean isValidCentralMeridian(double lambda0) {
        int ilambda0 = (int)Math.round(lambda0 * 57.29577951308232);
        int ilambda = 0;
        switch (this.projectionType) {
            case GK_3: 
            case GK_6: 
            case MGI_DKSBiH_GK: {
                ilambda = (int)Math.round(this.getGKCentralMeridian(1) * 57.29577951308232);
                break;
            }
            default: {
                ilambda = (int)Math.round(this.getUTMCentralMeridian(1) * 57.29577951308232);
            }
        }
        return Math.abs(ilambda0 - ilambda) % this.projectionType.getZoneWidth() == 0;
    }

    public String toString() {
        return this.projectionType.getLabel();
    }

    public ProjectionType getType() {
        return this.projectionType;
    }

    public void useApproximation(boolean approximation) {
        this.useApproximation = approximation;
    }

    public boolean useApproximation() {
        return this.useApproximation;
    }
}

