/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.earth.datum;

public enum GeodeticDatumType {
    ETRS89("ETRS89"),
    DHDN("DHDN"),
    RD83("RD/83"),
    PD83("PD/83"),
    S4283("S42/83"),
    MGI_A("MGI-A"),
    WGS84_N("WGS84 (N)"),
    WGS84_S("WGS84 (S)"),
    ED50("ED50"),
    DKSBiH("DKSBiH"),
    BH_ETRS89("BH_ETRS89"),
    UNKNOWN_SOURCE_GEODETIC_DATUM("<SRC>"),
    UNKNOWN_TARGET_GEODETIC_DATUM("<TRG>"),
    UNDEFINED("<USER>");

    private String label = "";

    private GeodeticDatumType(String label) {
        this.label = label;
    }

    public boolean setLabel(String label) {
        if (!(label == null || label.trim().isEmpty() || this != UNKNOWN_SOURCE_GEODETIC_DATUM && this != UNKNOWN_TARGET_GEODETIC_DATUM && this != UNDEFINED)) {
            this.label = label.trim();
            return true;
        }
        return false;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.label;
    }

    private static final String getRegEx(GeodeticDatumType type) {
        switch (type) {
            case BH_ETRS89: {
                return "(?i).*BH.*ETRS?.*89.*(?-i)";
            }
            case ETRS89: {
                return "(?i).*ETRS?.*89.*(?-i)";
            }
            case DHDN: {
                return "(?i).*DHDN.*(?-i)";
            }
            case DKSBiH: {
                return "(?i).*DKSBiH.*(?-i)";
            }
            case MGI_A: {
                return "(?i).*MGI.*(?-i)";
            }
            case RD83: {
                return "(?i).*RD.*83.*(?-i)";
            }
            case PD83: {
                return "(?i).*PD.*83.*(?-i)";
            }
            case S4283: {
                return "(?i).*[S4].*4?2.*83.*(?-i)";
            }
            case WGS84_N: 
            case WGS84_S: {
                return "(?i).*WGS.*84.*(?-i)";
            }
        }
        return null;
    }

    public static GeodeticDatumType valueByName(String name) {
        GeodeticDatumType[] geodeticDatumTypeArray = GeodeticDatumType.values();
        int n = geodeticDatumTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GeodeticDatumType type = geodeticDatumTypeArray[n2];
            String regex = GeodeticDatumType.getRegEx(type);
            if (type.name().equals(name) || regex != null && name.matches(regex) || type.label.equals(name)) {
                return type;
            }
            ++n2;
        }
        return UNDEFINED;
    }

    public static GeodeticDatumType[] values() {
        GeodeticDatumType[] geodeticDatumTypeArray = ENUM$VALUES;
        int n = geodeticDatumTypeArray.length;
        GeodeticDatumType[] geodeticDatumTypeArray2 = new GeodeticDatumType[n];
        System.arraycopy(ENUM$VALUES, 0, geodeticDatumTypeArray2, 0, n);
        return geodeticDatumTypeArray2;
    }
}

