/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.earth.datum;

import com.derletztekick.geodesy.earth.datum.GeodeticDatumType;
import com.derletztekick.geodesy.earth.ellipsoid.Ellipsoid;
import com.derletztekick.geodesy.earth.ellipsoid.EllipsoidType;
import com.derletztekick.geodesy.earth.projection.MapProjection;
import com.derletztekick.geodesy.earth.projection.ProjectionType;
import com.derletztekick.geodesy.earth.transformation.Helmert3D;

public class GeodeticDatum {
    private MapProjection projection;
    private GeodeticDatumType datum;
    private double tx = 0.0;
    private double ty = 0.0;
    private double tz = 0.0;
    private double rx = 0.0;
    private double ry = 0.0;
    private double rz = 0.0;
    private double m = 1.0;

    public GeodeticDatum(GeodeticDatumType datum) {
        this.datum = datum == GeodeticDatumType.UNDEFINED ? GeodeticDatumType.WGS84_N : datum;
        this.init();
    }

    public GeodeticDatum(GeodeticDatumType datum, double tx, double ty, double tz, double m, double rx, double ry, double rz) {
        this.datum = datum == GeodeticDatumType.UNDEFINED ? GeodeticDatumType.WGS84_N : datum;
        this.init();
        this.tx = tx;
        this.ty = ty;
        this.tz = tz;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
        this.m = m;
    }

    public GeodeticDatum(GeodeticDatumType datumType, MapProjection projection) {
        this(datumType, projection, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
    }

    public GeodeticDatum(GeodeticDatumType datumType, MapProjection projection, double tx, double ty, double tz, double m, double rx, double ry, double rz) {
        this.datum = datumType;
        this.projection = projection;
        this.tx = tx;
        this.ty = ty;
        this.tz = tz;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
        this.m = m;
    }

    private void init() {
        switch (this.datum) {
            case ETRS89: {
                this.projection = new MapProjection(new Ellipsoid(EllipsoidType.GRS80), ProjectionType.UTM_N);
                this.rz = 0.0;
                this.ry = 0.0;
                this.rx = 0.0;
                this.tz = 0.0;
                this.ty = 0.0;
                this.tx = 0.0;
                this.m = 1.0;
                break;
            }
            case DHDN: 
            case RD83: 
            case PD83: {
                this.projection = new MapProjection(new Ellipsoid(EllipsoidType.BESSEL), ProjectionType.GK_3);
                this.tx = 598.1;
                this.ty = 73.7;
                this.tz = 418.2;
                this.m = 1.0000067;
                this.rx = -9.793236358412627E-7;
                this.ry = -2.1816615649929117E-7;
                this.rz = 1.1902175871239108E-5;
                break;
            }
            case S4283: {
                this.projection = new MapProjection(new Ellipsoid(EllipsoidType.KRASSOWSKI), ProjectionType.GK_3);
                this.tx = 24.9;
                this.ty = -126.4;
                this.tz = -93.2;
                this.m = 1.00000101;
                this.rx = 3.054326190990077E-7;
                this.ry = 1.197489792340554E-6;
                this.rz = 1.987736092549098E-7;
                break;
            }
            case ED50: {
                this.projection = new MapProjection(new Ellipsoid(EllipsoidType.HAYFORD), ProjectionType.UTM_N);
                this.tx = -102.0;
                this.ty = -102.0;
                this.tz = -129.0;
                this.m = 1.0000025;
                this.rx = 1.939254724438144E-6;
                this.ry = -9.69627362219072E-7;
                this.rz = 1.939254724438144E-6;
                break;
            }
            case MGI_A: {
                this.projection = new MapProjection(new Ellipsoid(EllipsoidType.BESSEL), ProjectionType.MGI_M31);
                this.tx = 577.326;
                this.ty = 90.129;
                this.tz = 463.919;
                this.m = 1.000002423205872;
                this.rx = -2.490487879859686E-5;
                this.ry = -7.14615365955456E-6;
                this.rz = -2.568058068837212E-5;
                break;
            }
            case DKSBiH: {
                this.projection = new MapProjection(new Ellipsoid(EllipsoidType.BESSEL), ProjectionType.MGI_DKSBiH_GK);
                this.tx = 472.8677;
                this.ty = 187.8769;
                this.tz = 544.7084;
                this.m = 1.00000154517287;
                this.rx = -2.7934887801932587E-5;
                this.ry = -2.580316194913122E-5;
                this.rz = 6.208848539414989E-5;
                break;
            }
            case BH_ETRS89: {
                this.projection = new MapProjection(new Ellipsoid(EllipsoidType.GRS80), ProjectionType.MGI_DKSBiH_UTM);
                this.rz = 0.0;
                this.ry = 0.0;
                this.rx = 0.0;
                this.tz = 0.0;
                this.ty = 0.0;
                this.tx = 0.0;
                this.m = 1.0;
                break;
            }
            case WGS84_S: {
                this.projection = new MapProjection(new Ellipsoid(EllipsoidType.WGS84), ProjectionType.UTM_S);
                this.rz = 0.0;
                this.ry = 0.0;
                this.rx = 0.0;
                this.tz = 0.0;
                this.ty = 0.0;
                this.tx = 0.0;
                this.m = 1.0;
                break;
            }
            default: {
                this.projection = new MapProjection(new Ellipsoid(EllipsoidType.WGS84), ProjectionType.UTM_N);
                this.rz = 0.0;
                this.ry = 0.0;
                this.rx = 0.0;
                this.tz = 0.0;
                this.ty = 0.0;
                this.tx = 0.0;
                this.m = 1.0;
            }
        }
    }

    public Helmert3D getTransformationFromLocalToWGS84() {
        return new Helmert3D(this.tx, this.ty, this.tz, this.m, this.rx, this.ry, this.rz);
    }

    public GeodeticDatumType getType() {
        return this.datum;
    }

    public MapProjection getProjection() {
        return this.projection;
    }

    public String getName() {
        return this.datum.getLabel();
    }

    public String toString() {
        return this.getName() + "(" + this.projection.toString() + ", " + this.projection.getEllipsoid().getName() + ")";
    }
}

