/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.math.density;

import jdistlib.math.UnivariateFunction;
import jdistlib.math.VectorMath;
import jdistlib.math.opt.Optimization;

public class Bandwidth {
    public static final Bandwidth NRD0 = new Bandwidth(){

        @Override
        public double calculate(double[] x) {
            return 1.NRD0(x);
        }
    };
    public static final Bandwidth NRD = new Bandwidth(){

        @Override
        public double calculate(double[] x) {
            return 2.NRD(x);
        }
    };
    public static final Bandwidth UCV = new Bandwidth(){

        @Override
        public double calculate(double[] x) {
            return 3.CV(x, this.nb, this.lower, this.upper, this.tol, true);
        }
    };
    public static final Bandwidth BCV = new Bandwidth(){

        @Override
        public double calculate(double[] x) {
            return 4.CV(x, this.nb, this.lower, this.upper, this.tol, false);
        }
    };
    public static final Bandwidth SJ_STE = new Bandwidth(){

        @Override
        public double calculate(double[] x) {
            return 5.SJ(x, this.nb, this.lower, this.upper, this.tol, false);
        }
    };
    public static final Bandwidth SJ_DPI = new Bandwidth(){

        @Override
        public double calculate(double[] x) {
            return 6.SJ(x, this.nb, this.lower, this.upper, this.tol, true);
        }
    };
    double lower = Double.NaN;
    double upper = Double.NaN;
    double tol = Double.NaN;
    int nb = 1000;

    public double calculate(double[] x) {
        throw new RuntimeException("Unknown bandwidth rule");
    }

    public static final double NRD0(double[] x) {
        double hi = VectorMath.sd(x);
        double lo = Math.min(hi, VectorMath.iqr(x) / 1.34);
        if (lo == 0.0) {
            if (hi == 0.0) {
                lo = Math.abs(x[0]);
                if (lo == 0.0) {
                    lo = 1.0;
                }
            } else {
                lo = hi;
            }
        }
        return 0.9 * lo * Math.pow(x.length, -0.2);
    }

    public static final double NRD(double[] x) {
        double h = VectorMath.iqr(x) / 1.34;
        return 1.06 * Math.min(Math.sqrt(VectorMath.var(x)), h) * Math.pow(x.length, -0.2);
    }

    public static final double CV(double[] x, int nb, double lower, double upper, double tol, boolean isUnbiased) {
        double xmax;
        if (nb <= 0) {
            throw new RuntimeException();
        }
        int n = x.length;
        double hmax = 1.144 * VectorMath.sd(x) * Math.pow(n, -0.2);
        if (Double.isNaN(lower)) {
            lower = 0.1 * hmax;
        }
        if (Double.isNaN(upper)) {
            upper = hmax;
        }
        if (Double.isNaN(tol)) {
            tol = 0.1 * lower;
        }
        int[] cnt = new int[nb];
        double xmin = xmax = x[0];
        int i = 1;
        while (i < n) {
            if (xmin > x[i]) {
                xmin = x[i];
            }
            if (xmax < x[i]) {
                xmax = x[i];
            }
            ++i;
        }
        double dd = (xmax - xmin) * 1.01 / (double)nb;
        i = 1;
        while (i < n) {
            int ii = (int)(x[i] / dd);
            int j = 0;
            while (j < i) {
                int jj = (int)(x[j] / dd);
                int n2 = Math.abs(ii - jj);
                cnt[n2] = cnt[n2] + 1;
                ++j;
            }
            ++i;
        }
        UnivariateFunction fun = null;
        fun = isUnbiased ? new UnivariateFunction(){
            double d;
            int n;
            int[] cnt;

            @Override
            public void setParameters(double ... params) {
                this.n = (int)params[0];
                this.d = params[1];
            }

            @Override
            public void setObjects(Object ... obj) {
                this.cnt = (int[])obj[0];
            }

            @Override
            public double eval(double h) {
                int nbin = this.cnt.length;
                int DELMAX = 1000;
                double sum = 0.0;
                int i = 0;
                while (i < nbin) {
                    double delta = (double)i * this.d / h;
                    if ((delta *= delta) >= 1000.0) break;
                    double term = Math.exp(-delta / 4.0) - Math.sqrt(8.0) * Math.exp(-delta / 2.0);
                    sum += term * (double)this.cnt[i];
                    ++i;
                }
                double u = 1.0 / ((double)(2 * this.n) * h * Math.sqrt(Math.PI)) + sum / ((double)(this.n * this.n) * h * Math.sqrt(Math.PI));
                return u;
            }
        } : new UnivariateFunction(){
            double d;
            int n;
            int[] cnt;

            @Override
            public void setParameters(double ... params) {
                this.n = (int)params[0];
                this.d = params[1];
            }

            @Override
            public void setObjects(Object ... obj) {
                this.cnt = (int[])obj[0];
            }

            @Override
            public double eval(double h) {
                int nbin = this.cnt.length;
                int DELMAX = 1000;
                double sum = 0.0;
                int i = 0;
                while (i < nbin) {
                    double delta = (double)i * this.d / h;
                    if ((delta *= delta) >= 1000.0) break;
                    double term = Math.exp(-delta / 4.0) * (delta * delta - 12.0 * delta + 12.0);
                    sum += term * (double)this.cnt[i];
                    ++i;
                }
                double u = 1.0 / ((double)(2 * this.n) * h * Math.sqrt(Math.PI)) + sum / ((double)(64 * this.n * this.n) * h * Math.sqrt(Math.PI));
                return u;
            }
        };
        fun.setParameters(n, dd);
        fun.setObjects(new Object[]{cnt});
        double h = Optimization.optimize(fun, lower, upper, tol, 1000);
        if (h < lower + tol | h > upper - tol) {
            System.err.println("Warning: minimum occurred at one end of the range");
        }
        return h;
    }

    public static final double SJ(double[] x, int nb, double lower, double upper, double tol, boolean isDPI) {
        double alph2;
        boolean isLimitUnspecified;
        double xmax;
        if (nb <= 0) {
            throw new RuntimeException();
        }
        int n = x.length;
        int[] cnt = new int[nb];
        double xmin = xmax = x[0];
        int i = 1;
        while (i < n) {
            if (xmin > x[i]) {
                xmin = x[i];
            }
            if (xmax < x[i]) {
                xmax = x[i];
            }
            ++i;
        }
        double dd = (xmax - xmin) * 1.01 / (double)nb;
        i = 1;
        while (i < n) {
            int ii = (int)(x[i] / dd);
            int j = 0;
            while (j < i) {
                int jj = (int)(x[j] / dd);
                int n2 = Math.abs(ii - jj);
                cnt[n2] = cnt[n2] + 1;
                ++j;
            }
            ++i;
        }
        double scale = Math.min(VectorMath.sd(x), VectorMath.iqr(x) / 1.349);
        double a = 1.24 * scale * Math.pow(n, -0.14285714285714285);
        double b = 1.23 * scale * Math.pow(n, -0.1111111111111111);
        double c1 = 1.0 / (2.0 * Math.sqrt(Math.PI) * (double)n);
        double TD = -Bandwidth.bw_phi6(n, dd, cnt, b);
        if (Double.isInfinite(TD) || TD <= 0.0) {
            throw new RuntimeException("sample is too sparse to find TD");
        }
        if (isDPI) {
            return Math.pow(c1 / Bandwidth.bw_phi4(n, dd, cnt, Math.pow(2.394 / ((double)n * TD), 0.14285714285714285)), 0.2);
        }
        double hmax = 1.144 * scale * Math.pow(n, -0.2);
        boolean bl = isLimitUnspecified = Double.isNaN(lower) || Double.isNaN(upper);
        if (Double.isNaN(lower)) {
            lower = 0.1 * hmax;
        }
        if (Double.isNaN(upper)) {
            upper = hmax;
        }
        if (Double.isNaN(tol)) {
            tol = 0.1 * lower;
        }
        if (Double.isInfinite(alph2 = 1.357 * Math.pow(Bandwidth.bw_phi4(n, dd, cnt, a) / TD, 0.14285714285714285))) {
            throw new RuntimeException("sample is too sparse to find alph2");
        }
        UnivariateFunction fSD = new UnivariateFunction(){
            int n;
            double d;
            double c1;
            double alph2;
            int[] cnt;

            @Override
            public double eval(double h) {
                double v = Math.pow(this.c1 / Bandwidth.bw_phi4(this.n, this.d, this.cnt, this.alph2 * Math.pow(h, 0.7142857142857143)), 0.2) - h;
                return v;
            }

            @Override
            public void setParameters(double ... params) {
                this.n = (int)params[0];
                this.d = params[1];
                this.c1 = params[2];
                this.alph2 = params[3];
            }

            @Override
            public void setObjects(Object ... obj) {
                this.cnt = (int[])obj[0];
            }
        };
        fSD.setParameters(n, dd, c1, alph2);
        fSD.setObjects(new Object[]{cnt});
        int itry = 1;
        while (fSD.eval(lower) * fSD.eval(upper) > 0.0) {
            if (itry > 99 || !isLimitUnspecified) {
                throw new RuntimeException("no solution in the specified range of bandwidths");
            }
            if ((itry & 1) == 0) {
                upper *= 1.2;
            } else {
                lower /= 1.2;
            }
            ++itry;
        }
        double res = Optimization.zeroin(fSD, lower, upper, tol, 1000);
        return res;
    }

    private static final double bw_phi4(int n, double d, int[] cnt, double h) {
        int nbin = cnt.length;
        int DELMAX = 1000;
        double sum = 0.0;
        int i = 0;
        while (i < nbin) {
            double delta = (double)i * d / h;
            if ((delta *= delta) >= 1000.0) break;
            double term = Math.exp(-delta / 2.0) * (delta * delta - 6.0 * delta + 3.0);
            sum += term * (double)cnt[i];
            ++i;
        }
        sum = 2.0 * sum + (double)(n * 3);
        double u = sum / ((double)(n * (n - 1)) * Math.pow(h, 5.0) * Math.sqrt(Math.PI * 2));
        return u;
    }

    private static final double bw_phi6(int n, double d, int[] cnt, double h) {
        int nbin = cnt.length;
        int DELMAX = 1000;
        double sum = 0.0;
        int i = 0;
        while (i < nbin) {
            double delta = (double)i * d / h;
            if ((delta *= delta) >= 1000.0) break;
            double term = Math.exp(-delta / 2.0) * (delta * delta * delta - 15.0 * delta * delta + 45.0 * delta - 15.0);
            sum += term * (double)cnt[i];
            ++i;
        }
        sum = 2.0 * sum - (double)(15 * n);
        double u = sum / ((double)(n * (n - 1)) * Math.pow(h, 7.0) * Math.sqrt(Math.PI * 2));
        return u;
    }

    public int getNumBins() {
        return this.nb;
    }

    public void setNumBins(int nb) {
        this.nb = nb;
    }

    public double getLower() {
        return this.lower;
    }

    public void setLower(double lower) {
        this.lower = lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public void setUpper(double upper) {
        this.upper = upper;
    }

    public double getTolerance() {
        return this.tol;
    }

    public void setTolerance(double tol) {
        this.tol = tol;
    }
}

