/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.math.approx;

import jdistlib.math.UnivariateFunction;
import jdistlib.math.approx.ApproximationType;

public class ApproximationFunction
implements UnivariateFunction {
    protected double[] mX;
    protected double[] mY;
    protected double mLo;
    protected double mHi;
    protected double mCompromise;
    protected ApproximationType mType;

    public ApproximationFunction(ApproximationType t, double[] x, double[] y, double lo, double hi, double compromise) {
        assert (compromise >= 0.0 && compromise <= 1.0 && x.length == y.length && (t == ApproximationType.CONSTANT || t == ApproximationType.LINEAR));
        this.mX = x;
        this.mY = y;
        this.mLo = lo;
        this.mHi = hi;
        this.mCompromise = compromise;
        this.mType = t;
    }

    @Override
    public double eval(double x) {
        switch (this.mType) {
            case CONSTANT: {
                return ApproximationFunction.constant(x, this.mX, this.mY, this.mLo, this.mHi, this.mCompromise);
            }
            case LINEAR: {
                return ApproximationFunction.linear(x, this.mX, this.mY, this.mLo, this.mHi);
            }
        }
        throw new RuntimeException();
    }

    @Override
    public void setParameters(double ... params) {
    }

    @Override
    public void setObjects(Object ... obj) {
    }

    /*
     * Unable to fully structure code
     */
    public static final double linear(double v, double[] x, double[] y, double lo, double hi) {
        left = 0;
        right = x.length - 1;
        if (v < x[left]) {
            return lo;
        }
        if (!(v > x[right])) ** GOTO lbl12
        return hi;
lbl-1000:
        // 1 sources

        {
            mid = (left + right) / 2;
            if (v < x[mid]) {
                right = mid;
                continue;
            }
            left = mid;
lbl12:
            // 3 sources

            ** while (left < right - 1)
        }
lbl13:
        // 1 sources

        if (v == x[right]) {
            return y[right];
        }
        if (v == x[left]) {
            return y[left];
        }
        v = y[left] + (y[right] - y[left]) * ((v - x[left]) / (x[right] - x[left]));
        return v;
    }

    /*
     * Unable to fully structure code
     */
    public static final double constant(double v, double[] x, double[] y, double lo, double hi, double compromise) {
        left = 0;
        right = x.length - 1;
        if (v < x[left]) {
            return lo;
        }
        if (!(v > x[right])) ** GOTO lbl12
        return hi;
lbl-1000:
        // 1 sources

        {
            mid = (left + right) / 2;
            if (v < x[mid]) {
                right = mid;
                continue;
            }
            left = mid;
lbl12:
            // 3 sources

            ** while (left < right - 1)
        }
lbl13:
        // 1 sources

        if (v == x[right]) {
            return y[right];
        }
        if (v == x[left]) {
            return y[left];
        }
        return y[left] * compromise + y[right] * (1.0 - compromise);
    }
}

