/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.evd;

import jdistlib.evd.GEV;
import jdistlib.generic.GenericDistribution;
import jdistlib.rng.RandomEngine;

public class Gumbel
extends GenericDistribution {
    protected double loc;
    protected double scale;

    public static final double density(double x, double loc, double scale, boolean log) {
        return GEV.density(x, loc, scale, 0.0, log);
    }

    public static final double cumulative(double q, double loc, double scale, boolean lower_tail) {
        return GEV.cumulative(q, loc, scale, 0.0, lower_tail);
    }

    public static final double quantile(double p, double loc, double scale, boolean lower_tail) {
        return GEV.quantile(p, loc, scale, 0.0, lower_tail);
    }

    public static final double random(double loc, double scale, RandomEngine random) {
        return GEV.random(loc, scale, 0.0, random);
    }

    public static final double[] random(int n, double loc, double scale, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = Gumbel.random(loc, scale, random);
            ++i;
        }
        return rand;
    }

    public Gumbel(double loc, double scale) {
        this.loc = loc;
        this.scale = scale;
    }

    @Override
    public double density(double x, boolean log) {
        return Gumbel.density(x, this.loc, this.scale, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        p = Gumbel.cumulative(p, this.loc, this.scale, lower_tail);
        return log_p ? Math.log(p) : p;
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        if (log_p) {
            q = Math.exp(q);
        }
        return Gumbel.quantile(q, this.loc, this.scale, lower_tail);
    }

    @Override
    public double random() {
        return Gumbel.random(this.loc, this.scale, this.random);
    }
}

