/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.evd;

import jdistlib.Beta;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Extreme
extends GenericDistribution {
    protected int mlen;
    protected boolean largest;
    protected GenericDistribution dist;

    public static final double density(double x, GenericDistribution dist, int mlen, boolean largest, boolean log) {
        if (mlen <= 0) {
            return Double.NaN;
        }
        double dens = dist.density(x, true);
        if (MathFunctions.isInfinite(dens)) {
            return Double.NEGATIVE_INFINITY;
        }
        double cum = dist.cumulative(x, true, log);
        if (!largest) {
            cum = 1.0 - cum;
        }
        cum = (double)(mlen - 1) * Math.log(cum);
        x = Math.log(mlen) + dens + cum;
        return !log ? Math.exp(x) : x;
    }

    public static final double cumulative(double q, GenericDistribution dist, int mlen, boolean largest, boolean lower_tail) {
        if (mlen <= 0) {
            return Double.NaN;
        }
        double distn = dist.cumulative(q, lower_tail, false);
        if (!largest) {
            distn = 1.0 - distn;
        }
        q = Math.pow(distn, mlen);
        return largest != lower_tail ? 1.0 - q : q;
    }

    public static final double quantile(double p, GenericDistribution dist, int mlen, boolean largest, boolean lower_tail) {
        if (mlen <= 0) {
            return Double.NaN;
        }
        if (!lower_tail) {
            p = 1.0 - p;
        }
        return largest ? dist.quantile(Math.pow(p, 1.0 / (double)mlen), lower_tail, false) : dist.quantile(1.0 - Math.pow(1.0 - p, 1.0 / (double)mlen), lower_tail, false);
    }

    public static final double random(GenericDistribution dist, int mlen, boolean largest, RandomEngine random) {
        return largest ? dist.quantile(Beta.random(mlen, 1.0, random), true, false) : dist.quantile(Beta.random(1.0, mlen, random), true, false);
    }

    public static final double[] random(int n, GenericDistribution dist, int mlen, boolean largest, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = Extreme.random(dist, mlen, largest, random);
            ++i;
        }
        return rand;
    }

    public Extreme(GenericDistribution dist, int mlen, boolean largest) {
        this.dist = dist;
        this.mlen = mlen;
        this.largest = largest;
    }

    @Override
    public double density(double x, boolean log) {
        return Extreme.density(x, this.dist, this.mlen, this.largest, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        p = Extreme.cumulative(p, this.dist, this.mlen, this.largest, lower_tail);
        return log_p ? Math.log(p) : p;
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        if (log_p) {
            q = Math.exp(q);
        }
        return Extreme.quantile(q, this.dist, this.mlen, this.largest, lower_tail);
    }

    @Override
    public double random() {
        return Extreme.random(this.dist, this.mlen, this.largest, this.random);
    }
}

