/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.disttest;

import java.util.HashSet;
import jdistlib.ChiSquare;
import jdistlib.Normal;
import jdistlib.disttest.DistributionTest;
import jdistlib.disttest.TestKind;
import jdistlib.disttest.Utils;
import jdistlib.exception.PrecisionException;
import jdistlib.util.Utilities;

public class NormalityTest {
    public static final double shapiro_wilk_statistic(double[] X) {
        return NormalityTest.shapiro_wilk_statistic(X, false);
    }

    public static final double shapiro_wilk_statistic(double[] x, boolean sort) {
        double xx;
        double[] c1 = new double[]{0.0, 0.221157, -0.147981, -2.07119, 4.434685, -2.706056};
        double[] c2 = new double[]{0.0, 0.042981, -0.293762, -1.752461, 5.682633, -3.582633};
        int n = x.length;
        int n2 = n / 2;
        if (n < 3) {
            return 0.0;
        }
        double[] X = x;
        if (sort) {
            X = new double[n];
            System.arraycopy(x, 0, X, 0, n);
            Utilities.sort(X);
        }
        double[] a = new double[n2];
        if (n == 3) {
            a[0] = 0.7071067811865476;
        } else {
            double fac;
            double an25 = (double)n + 0.25;
            double sum2 = 0.0;
            int i = 0;
            while (i < n2) {
                double val = a[i] = Normal.quantile(((double)i + 0.625) / an25, 0.0, 1.0, true, false);
                sum2 += val * val;
                ++i;
            }
            double sqrtSum2 = Math.sqrt(sum2 *= 2.0);
            double rsn = 1.0 / Math.sqrt(n);
            double a1 = NormalityTest.poly(c1, rsn) - a[0] / sqrtSum2;
            int i1 = 1;
            if (n > 5) {
                i1 = 2;
                double a2 = -a[1] / sqrtSum2 + NormalityTest.poly(c2, rsn);
                fac = -Math.sqrt((sum2 - 2.0 * a[0] * a[0] - 2.0 * a[1] * a[1]) / (1.0 - 2.0 * a1 * a1 - 2.0 * a2 * a2));
                a[1] = a2;
            } else {
                fac = -Math.sqrt((sum2 - 2.0 * a[0] * a[0]) / (1.0 - 2.0 * a1 * a1));
            }
            a[0] = a1;
            int i2 = i1;
            while (i2 < n2) {
                int n3 = i2++;
                a[n3] = a[n3] / fac;
            }
        }
        double range = X[n - 1] - X[0];
        if (range < 1.0E-19) {
            throw new PrecisionException("Shapiro-Wilks error: Range too small!", range);
        }
        double sx = xx = X[0] / range;
        double sa = -a[0];
        int j = n - 1;
        int i = 1;
        while (i < n) {
            double xi = X[i] / range;
            sx += xi;
            if (++i != j) {
                sa += (double)Math.signum(i - j) * a[Math.min(i, j) - 1];
            }
            xx = xi;
            --j;
        }
        double ssa = 0.0;
        double ssx = 0.0;
        double sax = 0.0;
        sa /= (double)n;
        sx /= (double)n;
        j = n - 1;
        int i3 = 0;
        while (i3 < n) {
            double asa = i3 != j ? (double)Math.signum(i3 - j) * a[Math.min(i3, j)] - sa : -sa;
            double xsx = X[i3] / range - sx;
            ssa += asa * asa;
            ssx += xsx * xsx;
            sax += asa * xsx;
            ++i3;
            --j;
        }
        double ssassx = Math.sqrt(ssa * ssx);
        double w1 = (ssassx - sax) * (ssassx + sax) / (ssa * ssx);
        return 1.0 - w1;
    }

    public static final double shapiro_wilk_pvalue(double w, int n) {
        double s;
        double m;
        double kVerySmallValue = 1.0E-99;
        double[] c3 = new double[]{0.544, -0.39978, 0.025054, -6.714E-4};
        double[] c4 = new double[]{1.3822, -0.77857, 0.062767, -0.0020322};
        double[] c5 = new double[]{-1.5861, -0.31082, -0.083751, 0.0038915};
        double[] c6 = new double[]{-0.4803, -0.082676, 0.0030302};
        double[] g = new double[]{-2.273, 0.459};
        if (n < 3) {
            return 1.0;
        }
        if (n == 3) {
            return Math.max(0.0, 1.90985931710274 * (Math.asin(Math.sqrt(w)) - 1.0471975511966));
        }
        double y = Math.log(1.0 - w);
        double xx = Math.log(n);
        if (n <= 11) {
            double gamma = NormalityTest.poly(g, n);
            if (y >= gamma) {
                return 1.0E-99;
            }
            y = -Math.log(gamma - y);
            m = NormalityTest.poly(c3, n);
            s = Math.exp(NormalityTest.poly(c4, n));
        } else {
            m = NormalityTest.poly(c5, xx);
            s = Math.exp(NormalityTest.poly(c6, xx));
        }
        return Normal.cumulative(y, m, s, false, false);
    }

    public static final double anderson_darling_statistic(double[] X) {
        int n = X.length;
        double sum = 0.0;
        double sumSq = 0.0;
        int i = 0;
        while (i < n) {
            double value = X[i];
            sum += value;
            sumSq += value * value;
            ++i;
        }
        double mean = sum / (double)n;
        double sd = Math.sqrt((sumSq - sum * mean) / (double)(n - 1));
        double[] Y = new double[n];
        int i2 = 0;
        while (i2 < n) {
            Y[i2] = (X[i2] - mean) / sd;
            ++i2;
        }
        Utilities.sort(Y);
        i2 = 0;
        while (i2 < n) {
            Y[i2] = Normal.cumulative(Y[i2], 0.0, 1.0, true, false);
            ++i2;
        }
        sum = 0.0;
        i2 = 1;
        while (i2 <= n) {
            sum += (double)(2 * i2 - 1) * (Math.log(Y[i2 - 1]) + Math.log(1.0 - Y[n - i2]));
            ++i2;
        }
        return (double)(-n) - sum / (double)n;
    }

    public static final double anderson_darling_pvalue(double value, int n) {
        double aa = value * (1.0 + 0.75 / (double)n + 2.25 / (double)(n * n));
        double aasq = aa * aa;
        if (aa < 0.2) {
            return 1.0 - Math.exp(-13.436 + 101.14 * aa - 223.73 * aasq);
        }
        if (aa < 0.34) {
            return 1.0 - Math.exp(-8.318 + 42.796 * aa - 59.938 * aasq);
        }
        if (aa < 0.6) {
            return Math.exp(0.9177 - 4.279 * aa - 1.38 * aasq);
        }
        return Math.exp(1.2937 - 5.709 * aa + 0.0186 * aasq);
    }

    public static final double cramer_vonmises_statistic(double[] X) {
        int n = X.length;
        int n2 = n * 2;
        double w = 0.0;
        double sum = 0.0;
        double sumSq = 0.0;
        int i = 0;
        while (i < n) {
            double val = X[i];
            sum += val;
            sumSq += val * val;
            ++i;
        }
        double mean = sum / (double)n;
        double sd = Math.sqrt((sumSq - sum * mean) / (double)(n - 1));
        double[] sortedZ = new double[n];
        int i2 = 0;
        while (i2 < n) {
            sortedZ[i2] = Normal.cumulative(X[i2], mean, sd, true, false);
            ++i2;
        }
        Utilities.sort(sortedZ);
        w = 1.0 / (double)(12 * n);
        i2 = 0;
        while (i2 < n) {
            double val = ((double)(2 * i2) + 1.0) / (double)n2 - sortedZ[i2];
            w += val * val;
            ++i2;
        }
        return w;
    }

    public static final double cramer_vonmises_pvalue(double w, int n) {
        double ww = (1.0 + 0.5 / (double)n) * w;
        double ww2 = ww * ww;
        if (ww < 0.0275) {
            return 1.0 - Math.exp(-13.953 + 775.5 * ww - 12542.61 * ww2);
        }
        if (ww < 0.051) {
            return 1.0 - Math.exp(-5.903 + 179.546 * ww - 1515.29 * ww2);
        }
        if (ww < 0.092) {
            return Math.exp(0.886 - 31.62 * ww + 10.897 * ww2);
        }
        return (ww = Math.exp(1.111 - 34.242 * ww + 12.832 * ww2)) > 1.0 ? 0.0 : ww;
    }

    public static final double dagostino_pearson_statistic(double[] X) {
        double z2;
        int n = X.length;
        int nSq = n * n;
        int nCube = n * nSq;
        double nMin1 = n - 1;
        double nn1 = (double)n * nMin1;
        double n1n3 = (n + 1) * (n + 3);
        double nMin2 = n - 2;
        double n2n3 = nMin2 * (double)(n - 3);
        double n3n5 = (n + 3) * (n + 5);
        double n7n9 = (n + 7) * (n + 9);
        double sum = 0.0;
        double sumSq = 0.0;
        double sumCube = 0.0;
        double sumQuad = 0.0;
        int i = 0;
        while (i < n) {
            double val = X[i];
            double valsq = val * val;
            sum += val;
            sumSq += valsq;
            sumCube += valsq * val;
            sumQuad += valsq * valsq;
            ++i;
        }
        double sumsum = sum * sum;
        double kurtosis = ((double)(nCube + nSq) * sumQuad - (double)(4 * (nSq + n)) * sumCube * sum - (double)(3 * (nSq - n)) * sumSq * sumSq + (double)(12 * n) * sumSq * sumsum - 6.0 * sumsum * sumsum) / (nn1 * n2n3);
        double skewness = ((double)n * sumCube - 3.0 * sum * sumSq + 2.0 * sumsum * sum / (double)n) / (nMin1 * nMin2);
        double variance = (sumSq - sumsum / (double)n) / nMin1;
        double c = Math.sqrt(2.0 * ((double)(3 * (nSq + 27 * n - 70)) * n1n3 / (nMin2 * (double)(n + 5) * n7n9)) - 1.0) - 1.0;
        double f = nMin2 * skewness / (variance * Math.sqrt(variance) * Math.sqrt(nn1)) * Math.sqrt(n1n3 * (c - 1.0) / (12.0 * nMin2));
        double jinv = n7n9 / ((double)(6 * nSq - 30 * n + 12) * Math.sqrt(6.0 * n3n5 / ((double)n * n2n3)));
        double k = 6.0 + 8.0 * jinv * (2.0 * jinv + Math.sqrt(1.0 + 4.0 * jinv * jinv));
        double l = (1.0 - 2.0 / k) / (1.0 + Math.sqrt(n2n3 * n3n5 / (double)(24 * n)) * Math.abs(kurtosis / (variance * variance)) / nMin1 * Math.sqrt(2.0 / (k - 4.0)));
        double k2 = 2.0 / (9.0 * k);
        double z1 = Math.log(f + Math.sqrt(f * f + 1.0)) / Math.sqrt(0.5 * Math.log(c));
        double value = z1 * z1 + (z2 = (1.0 - k2 - Math.pow(l, 0.3333333333333333)) / Math.sqrt(k2)) * z2;
        return value > 50.0 ? 50.0 : value;
    }

    public static final double dagostino_pearson_pvalue(double value) {
        return ChiSquare.cumulative(value, 2.0, true, false);
    }

    public static final double jarque_bera_statistic(double[] X) {
        double kMin3;
        double value;
        int n = X.length;
        double sum = 0.0;
        double sumSq = 0.0;
        double sumCube = 0.0;
        double sumQuad = 0.0;
        int i = 0;
        while (i < n) {
            double val = X[i];
            sum += val;
            double valsq = val * val;
            sumSq += valsq;
            sumCube += valsq * val;
            sumQuad += valsq * valsq;
            ++i;
        }
        int nSq = n * n;
        int nCube = n * nSq;
        double sumsum = sum * sum;
        double variance = (sumSq - sum * sum / (double)n) / (double)n;
        double skewness = sumCube / (double)n - 3.0 * sumSq * sum / (double)nSq + 2.0 * sumsum * sum / (double)nCube;
        double kurtosis = sumQuad / (double)n - 4.0 * sumCube * sum / (double)nSq + 6.0 * sumSq * sumsum / (double)nCube - 3.0 * sumsum * sumsum / (double)(nSq * nSq);
        return (value = (double)n * ((skewness /= variance * Math.sqrt(variance)) * skewness + (kMin3 = (kurtosis /= variance * variance) - 3.0) * kMin3 / 4.0) / 6.0) > 50.0 ? 50.0 : value;
    }

    public static final double jarque_bera_pvalue(double value) {
        return ChiSquare.cumulative(value, 2.0, true, false);
    }

    public static final double[] kolmogorov_smirnov_test(double[] X) {
        return DistributionTest.kolmogorov_smirnov_test(X, new Normal());
    }

    public static final double kolmogorov_smirnov_statistic(double[] X) {
        return DistributionTest.kolmogorov_smirnov_statistic(X, new Normal(), TestKind.TWO_SIDED);
    }

    public static final double kolmogorov_smirnov_pvalue(double d, double[] X) {
        int nX = X.length;
        HashSet<Double> set = new HashSet<Double>(nX);
        double[] dArray = X;
        int n = X.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            set.add(x);
            ++n2;
        }
        if (set.size() < nX) {
            return DistributionTest.kolmogorov_smirnov_pvalue_inexact(d, nX);
        }
        return DistributionTest.kolmogorov_smirnov_pvalue_exact(d, nX);
    }

    public static final double kolmogorov_lilliefors_statistic(double[] X) {
        int n = X.length;
        double sum = 0.0;
        double sumSq = 0.0;
        int i = 0;
        while (i < n) {
            double val = X[i];
            sum += val;
            sumSq += val * val;
            ++i;
        }
        double mean = sum / (double)n;
        double sd = Math.sqrt((sumSq - sum * mean) / (double)(n - 1));
        double[] sortedZ = new double[n];
        int i2 = 0;
        while (i2 < n) {
            sortedZ[i2] = (X[i2] - mean) / sd;
            ++i2;
        }
        Utilities.sort(sortedZ);
        double[] cdfZ = Utils.calculate_ecdf(sortedZ);
        double max = 0.0;
        int i3 = 0;
        while (i3 < n) {
            double MPrime;
            double cdfNormal = Normal.cumulative(sortedZ[i3], 0.0, 1.0, true, false);
            double M = Math.abs(cdfNormal - cdfZ[i3]);
            double curMax = Math.max(M, MPrime = i3 > 0 ? Math.abs(cdfNormal - cdfZ[i3 - 1]) : Math.abs(cdfNormal));
            if (curMax > max) {
                max = curMax;
            }
            ++i3;
        }
        return max;
    }

    public static final double kolmogorov_lilliefors_pvalue(double k, int n) {
        double pvalue;
        double Kd = k;
        double nd = n;
        if (n > 100) {
            Kd = k * Math.pow((double)n / 100.0, 0.49);
            nd = 100.0;
        }
        if ((pvalue = Math.exp(-7.01256 * Kd * Kd * (nd + 2.78019) + 2.99587 * Kd * Math.sqrt(nd + 2.78019) - 0.122119 + 0.974598 / Math.sqrt(nd) + 1.67997 / nd)) > 0.1) {
            double KK = (Math.sqrt(n) - 0.01 + 0.85 / Math.sqrt(n)) * k;
            double KK2 = KK * KK;
            double KK3 = KK2 * KK;
            double KK4 = KK2 * KK2;
            if (KK <= 0.302) {
                return 1.0;
            }
            if (KK <= 0.5) {
                return 2.76773 - 19.828315 * KK + 80.709644 * KK2 - 138.55152 * KK3 + 81.218052 * KK4;
            }
            if (KK <= 0.9) {
                return -4.901232 + 40.662806 * KK - 97.490286 * KK2 + 94.029866 * KK3 - 32.355711 * KK4;
            }
            if (KK <= 1.31) {
                return 6.198765 - 19.558097 * KK + 23.186922 * KK2 - 12.234627 * KK3 + 2.423045 * KK4;
            }
            return 0.0;
        }
        return pvalue;
    }

    public static final double shapiro_francia_statistic(double[] X) {
        int n = X.length;
        double denum = (double)n + 0.25;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXSq = 0.0;
        double sumYSq = 0.0;
        double sumXY = 0.0;
        int i = 0;
        while (i < n) {
            double y = Normal.quantile(((double)i + 0.625) / denum, 0.0, 1.0, true, false);
            double x = X[i];
            sumX += x;
            sumY += y;
            sumXSq += x * x;
            sumYSq += y * y;
            sumXY += x * y;
            ++i;
        }
        double cor = ((double)n * sumXY - sumX * sumY) / (Math.sqrt((double)n * sumXSq - sumX * sumX) * Math.sqrt((double)n * sumYSq - sumY * sumY));
        return cor * cor;
    }

    public static final double shapiro_francia_pvalue(double w, int n) {
        double a = Math.log(n);
        double b = Math.log(a);
        double mu = -1.2725 + 1.0521 * (b - a);
        double sigma = 1.0308 - 0.26758 * (b + 2.0 / a);
        return Normal.cumulative(Math.log(1.0 - w), mu, sigma, false, false);
    }

    private static final double poly(double[] coeff, double x) {
        int n = coeff.length;
        double result = coeff[0];
        if (n > 1) {
            double p = x * coeff[n - 1];
            int i = n - 2;
            while (i > 0) {
                p = (p + coeff[i]) * x;
                --i;
            }
            result += p;
        }
        return result;
    }
}

