/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Normal
extends GenericDistribution {
    private static final double A = 2.216035867166471;
    public double mu;
    public double sigma;

    public static final double density(double x, double mu, double sigma, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(mu) || Double.isNaN(sigma)) {
            return x + mu + sigma;
        }
        if (MathFunctions.isInfinite(sigma)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (MathFunctions.isInfinite(x) && x == mu) {
            return Double.NaN;
        }
        if (sigma <= 0.0) {
            if (sigma == 0.0) {
                return x == mu ? Double.POSITIVE_INFINITY : (give_log ? Double.NEGATIVE_INFINITY : 0.0);
            }
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(x = (x - mu) / sigma)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (give_log) {
            return -(0.9189385332046728 + 0.5 * x * x + Math.log(sigma));
        }
        if (x < 5.0) {
            return 0.3989422804014327 * Math.exp(-0.5 * x * x) / sigma;
        }
        if (x > Math.sqrt(1487.4938494816427)) {
            return 0.0;
        }
        double x1 = MathFunctions.ldexp(Math.rint(MathFunctions.ldexp(x, 16)), -16);
        double x2 = x - x1;
        return 0.3989422804014327 / sigma * (Math.exp(-0.5 * x1 * x1) * Math.exp((-0.5 * x2 - x1) * x2));
    }

    public static final double cumulative_standard(double x) {
        return Normal.cumulative(x, 0.0, 1.0, true, false);
    }

    public static final double cumulative(double x, double mu, double sigma) {
        return Normal.cumulative(x, mu, sigma, true, false);
    }

    public static final double cumulative(double x, double mu, double sigma, boolean lower_tail, boolean log_p) {
        double SIXTEN = 16.0;
        double[] a = new double[]{2.2352520354606837, 161.02823106855587, 1067.6894854603709, 18154.98125334356, 0.06568233791820745};
        double[] b = new double[]{47.202581904688245, 976.0985517377767, 10260.932208618979, 45507.78933502673};
        double[] c = new double[]{0.39894151208813466, 8.883149794388377, 93.50665613217785, 597.2702763948002, 2494.5375852903726, 6848.190450536283, 11602.65143764735, 9842.714838383978, 1.0765576773720192E-8};
        double[] d = new double[]{22.266688044328117, 235.387901782625, 1519.3775994075547, 6485.558298266761, 18615.571640885097, 34900.95272114598, 38912.00328609327, 19685.429676859992};
        double[] p = new double[]{0.215898534057957, 0.12740116116024736, 0.022235277870649807, 0.0014216191932278934, 2.9112874951168793E-5, 0.023073441764940174};
        double[] q = new double[]{1.284260096144911, 0.4682382124808651, 0.06598813786892856, 0.0037823963320275824, 7.297515550839662E-5};
        if (Double.isNaN(x) || Double.isNaN(mu) || Double.isNaN(sigma)) {
            return x + mu + sigma;
        }
        if (sigma <= 0.0) {
            if (sigma < 0.0) {
                return Double.NaN;
            }
            return x < mu ? (lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0)) : (lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0));
        }
        double result = (x - mu) / sigma;
        double ccum = 0.0;
        if (MathFunctions.isInfinite(result)) {
            return x < mu ? (lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0)) : (lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0));
        }
        x = result;
        double eps = 1.110223E-16f;
        double min = Double.MIN_NORMAL;
        double y = Math.abs(x);
        if (y <= 0.67448975) {
            double xden;
            double xnum;
            if (y > eps) {
                double xsq = x * x;
                xnum = a[4] * xsq;
                xden = xsq;
                int i = 0;
                while (i < 3) {
                    xnum = (xnum + a[i]) * xsq;
                    xden = (xden + b[i]) * xsq;
                    ++i;
                }
            } else {
                xden = 0.0;
                xnum = 0.0;
            }
            double temp = x * (xnum + a[3]) / (xden + b[3]);
            if (lower_tail) {
                result = log_p ? Math.log(0.5 + temp) : 0.5 + temp;
            } else {
                ccum = log_p ? Math.log(0.5 - temp) : 0.5 - temp;
            }
        } else if (y <= 5.656854249492381) {
            double xnum = c[8] * y;
            double xden = y;
            int i = 0;
            while (i < 7) {
                xnum = (xnum + c[i]) * y;
                xden = (xden + d[i]) * y;
                ++i;
            }
            double temp = (xnum + c[7]) / (xden + d[7]);
            double xsq = MathFunctions.trunc(y * 16.0) / 16.0;
            double del = (y - xsq) * (y + xsq);
            if (log_p) {
                result = -xsq * xsq * 0.5 + -del * 0.5 + Math.log(temp);
                if (lower_tail && x > 0.0 || !lower_tail && x <= 0.0) {
                    ccum = Math.log1p(-Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp);
                }
            } else {
                result = Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp;
                ccum = 1.0 - result;
            }
            if (x > 0.0) {
                temp = result;
                if (lower_tail) {
                    result = ccum;
                }
                ccum = temp;
            }
        } else if (log_p && y < 1.0E170 || lower_tail && -37.5193 < x && x < 8.2924 || !lower_tail && -8.2924 < x && x < 37.5193) {
            double xsq = 1.0 / x;
            xsq *= xsq;
            double xnum = p[5] * xsq;
            double xden = xsq;
            int i = 0;
            while (i < 4) {
                xnum = (xnum + p[i]) * xsq;
                xden = (xden + q[i]) * xsq;
                ++i;
            }
            double temp = xsq * (xnum + p[4]) / (xden + q[4]);
            temp = (0.3989422804014327 - temp) / y;
            xsq = MathFunctions.trunc(x * 16.0) / 16.0;
            double del = (x - xsq) * (x + xsq);
            if (log_p) {
                result = -xsq * xsq * 0.5 + -del * 0.5 + Math.log(temp);
                if (lower_tail && x > 0.0 || !lower_tail && x <= 0.0) {
                    ccum = Math.log1p(-Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp);
                }
            } else {
                result = Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp;
                ccum = 1.0 - result;
            }
            if (x > 0.0) {
                temp = result;
                if (lower_tail) {
                    result = ccum;
                }
                ccum = temp;
            }
        } else if (x > 0.0) {
            result = log_p ? 0.0 : 1.0;
            ccum = log_p ? Double.NEGATIVE_INFINITY : 0.0;
        } else {
            result = log_p ? Double.NEGATIVE_INFINITY : 0.0;
            double d2 = ccum = log_p ? 0.0 : 1.0;
        }
        if (log_p) {
            if (result > -min) {
                result = -0.0;
            }
            if (ccum > -min) {
                ccum = -0.0;
            }
        } else {
            if (result < min) {
                result = 0.0;
            }
            if (ccum < min) {
                ccum = 0.0;
            }
        }
        return lower_tail ? result : ccum;
    }

    public static final double quantile(double p, double mu, double sigma, boolean lower_tail, boolean log_p) {
        double val;
        if (Double.isNaN(p) || Double.isNaN(mu) || Double.isNaN(sigma)) {
            return p + mu + sigma;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
        }
        if (sigma < 0.0) {
            return Double.NaN;
        }
        if (sigma == 0.0) {
            return mu;
        }
        double p_ = log_p ? (lower_tail ? Math.exp(p) : -Math.expm1(p)) : (lower_tail ? p : 0.5 - p + 0.5);
        double q = p_ - 0.5;
        if (Math.abs(q) <= 0.425) {
            double r = 0.180625 - q * q;
            val = q * (((((((r * 2509.0809287301227 + 33430.57558358813) * r + 67265.7709270087) * r + 45921.95393154987) * r + 13731.69376550946) * r + 1971.5909503065513) * r + 133.14166789178438) * r + 3.3871328727963665) / (((((((r * 5226.495278852854 + 28729.085735721943) * r + 39307.89580009271) * r + 21213.794301586597) * r + 5394.196021424751) * r + 687.1870074920579) * r + 42.31333070160091) * r + 1.0);
        } else {
            double r = q > 0.0 ? (log_p ? (lower_tail ? -Math.expm1(p) : Math.exp(p)) : (lower_tail ? 0.5 - p + 0.5 : p)) : p_;
            r = Math.sqrt(-(log_p && (lower_tail && q <= 0.0 || !lower_tail && q > 0.0) ? p : Math.log(r)));
            val = r <= 5.0 ? ((((((((r += -1.6) * 7.745450142783414E-4 + 0.022723844989269184) * r + 0.2417807251774506) * r + 1.2704582524523684) * r + 3.6478483247632045) * r + 5.769497221460691) * r + 4.630337846156546) * r + 1.4234371107496835) / (((((((r * 1.0507500716444169E-9 + 5.475938084995345E-4) * r + 0.015198666563616457) * r + 0.14810397642748008) * r + 0.6897673349851) * r + 1.6763848301838038) * r + 2.053191626637759) * r + 1.0) : ((((((((r += -5.0) * 2.0103343992922881E-7 + 2.7115555687434876E-5) * r + 0.0012426609473880784) * r + 0.026532189526576124) * r + 0.29656057182850487) * r + 1.7848265399172913) * r + 5.463784911164114) * r + 6.657904643501103) / (((((((r * 2.0442631033899397E-15 + 1.421511758316446E-7) * r + 1.8463183175100548E-5) * r + 7.868691311456133E-4) * r + 0.014875361290850615) * r + 0.1369298809227358) * r + 0.599832206555888) * r + 1.0);
            if (q < 0.0) {
                val = -val;
            }
        }
        return mu + sigma * val;
    }

    public static final double random(double mu, double sigma, RandomEngine random) {
        return mu + sigma * Normal.random_standard(random);
    }

    public static final double random_standard(RandomEngine random) {
        double u1 = random.nextDouble();
        u1 = (double)((int)(1.34217728E8 * u1)) + random.nextDouble();
        u1 = Normal.quantile(u1 / 1.34217728E8, 0.0, 1.0, true, false);
        return u1;
    }

    public static final double[] random(int n, double mu, double sigma, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = Normal.random(mu, sigma, random);
            ++i;
        }
        return rand;
    }

    public static final double[] random_standard(int n, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = Normal.random_standard(random);
            ++i;
        }
        return rand;
    }

    public static final double random_ahrens_dieter(double mu, double sigma, RandomEngine random) {
        double w;
        double aa;
        double u2;
        double[] a = new double[]{0.0, 0.03917609, 0.07841241, 0.1177699, 0.1573107, 0.1970991, 0.2372021, 0.2776904, 0.3186394, 0.3601299, 0.4022501, 0.4450965, 0.4887764, 0.5334097, 0.5791322, 0.626099, 0.6744898, 0.7245144, 0.7764218, 0.8305109, 0.8871466, 0.9467818, 1.00999, 1.077516, 1.150349, 1.229859, 1.318011, 1.417797, 1.534121, 1.67594, 1.862732, 2.153875};
        double[] d = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.2636843, 0.2425085, 0.2255674, 0.2116342, 0.1999243, 0.1899108, 0.1812252, 0.1736014, 0.1668419, 0.1607967, 0.1553497, 0.1504094, 0.1459026, 0.14177, 0.1379632, 0.1344418, 0.1311722, 0.128126, 0.1252791, 0.1226109, 0.1201036, 0.1177417, 0.1155119, 0.1134023, 0.1114027, 0.1095039};
        double[] t = new double[]{7.673828E-4, 0.00230687, 0.003860618, 0.005438454, 0.007050699, 0.008708396, 0.01042357, 0.01220953, 0.01408125, 0.01605579, 0.0181529, 0.02039573, 0.02281177, 0.02543407, 0.02830296, 0.03146822, 0.03499233, 0.03895483, 0.04345878, 0.04864035, 0.05468334, 0.06184222, 0.07047983, 0.08113195, 0.09462444, 0.1123001, 0.136498, 0.1716886, 0.2276241, 0.330498, 0.5847031};
        double[] h = new double[]{0.03920617, 0.03932705, 0.03950999, 0.03975703, 0.04007093, 0.04045533, 0.04091481, 0.04145507, 0.04208311, 0.04280748, 0.04363863, 0.04458932, 0.04567523, 0.04691571, 0.04833487, 0.04996298, 0.05183859, 0.05401138, 0.05654656, 0.0595313, 0.06308489, 0.06737503, 0.07264544, 0.07926471, 0.08781922, 0.09930398, 0.1155599, 0.1404344, 0.1836142, 0.2790016, 0.7010474};
        double u1 = random.nextDouble();
        double s = 0.0;
        if (u1 > 0.5) {
            s = 1.0;
        }
        u1 = u1 + u1 - s;
        int i = (int)(u1 *= 32.0);
        if (i == 32) {
            i = 31;
        }
        if (i != 0) {
            u2 = u1 - (double)i;
            aa = a[i - 1];
            while (u2 <= t[i - 1]) {
                u1 = random.nextDouble();
                w = u1 * (a[i] - aa);
                double tt = (w * 0.5 + aa) * w;
                while (true) {
                    if (u2 > tt) {
                        double y = aa + w;
                        return mu + sigma * (s == 1.0 ? -y : y);
                    }
                    u1 = random.nextDouble();
                    if (u2 < u1) break;
                    tt = u1;
                    u2 = random.nextDouble();
                }
                u2 = random.nextDouble();
            }
        } else {
            i = 6;
            double aa2 = a[31];
            while (!((u1 += u1) >= 1.0)) {
                aa2 += d[i - 1];
                ++i;
            }
            u1 -= 1.0;
            while (true) {
                double w2 = u1 * d[i - 1];
                double tt = (w2 * 0.5 + aa2) * w2;
                while (true) {
                    double u22;
                    if ((u22 = random.nextDouble()) > tt) {
                        double y = aa2 + w2;
                        return mu + sigma * (s == 1.0 ? -y : y);
                    }
                    u1 = random.nextDouble();
                    if (u22 < u1) break;
                    tt = u1;
                }
                u1 = random.nextDouble();
            }
        }
        w = (u2 - t[i - 1]) * h[i - 1];
        double y = aa + w;
        return s == 1.0 ? -y : y;
    }

    private static final double g(double x) {
        double C1 = 0.398942280401433;
        double C2 = 0.180025191068563;
        return 0.398942280401433 * Math.exp(-x * x / 2.0) - 0.180025191068563 * (2.216035867166471 - x);
    }

    public static final double random_kinderman_ramage(double mu, double sigma, RandomEngine random) {
        double u3;
        double u2;
        double tt;
        double u1 = random.nextDouble();
        if (u1 < 0.884070402298758) {
            double u22 = random.nextDouble();
            return 2.216035867166471 * (1.13113163544418 * u1 + u22 - 1.0);
        }
        if (u1 >= 0.973310954173898) {
            double u32;
            double tt2;
            double u23;
            while (!((u23 = random.nextDouble()) * u23 < 4.910814964568252 / (tt2 = 4.910814964568252 - 2.0 * Math.log(u32 = random.nextDouble())))) {
            }
            return u1 < 0.986655477086949 ? Math.sqrt(tt2) : -Math.sqrt(tt2);
        }
        if (u1 >= 0.958720824790463) {
            double tt3;
            double u33;
            double u24;
            do {
                u24 = random.nextDouble();
                u33 = random.nextDouble();
                tt3 = 2.216035867166471 - 0.63083480192196 * Math.min(u24, u33);
                if (!(Math.max(u24, u33) <= 0.755591531667601)) continue;
                return u24 < u33 ? tt3 : -tt3;
            } while (!(0.034240503750111 * Math.abs(u24 - u33) <= Normal.g(tt3)));
            return u24 < u33 ? tt3 : -tt3;
        }
        if (u1 >= 0.911312780288703) {
            double tt4;
            double u34;
            double u25;
            do {
                u25 = random.nextDouble();
                u34 = random.nextDouble();
                tt4 = 0.479727404222441 + 1.10547366102207 * Math.min(u25, u34);
                if (!(Math.max(u25, u34) <= 0.87283497667179)) continue;
                return u25 < u34 ? tt4 : -tt4;
            } while (!(0.049264496373128 * Math.abs(u25 - u34) <= Normal.g(tt4)));
            return u25 < u34 ? tt4 : -tt4;
        }
        while (true) {
            if ((tt = 0.479727404222441 - 0.59550713801594 * Math.min(u2 = random.nextDouble(), u3 = random.nextDouble())) < 0.0) {
                continue;
            }
            if (Math.max(u2, u3) <= 0.805577924423817) {
                return u2 < u3 ? tt : -tt;
            }
            if (0.053377549506886 * Math.abs(u2 - u3) <= Normal.g(tt)) break;
        }
        return u2 < u3 ? tt : -tt;
    }

    public static final double random_box_muller(double mu, double sigma, RandomEngine random) {
        double theta = Math.PI * 2 * random.nextDouble();
        double R = Math.sqrt(-2.0 * Math.log(random.nextDouble())) + 2.2250738585072014E-307;
        return random.nextDouble() < 0.5 ? R * Math.cos(theta) : R * Math.sin(theta);
    }

    public Normal() {
        this(0.0, 1.0);
    }

    public Normal(double mu, double sigma) {
        this.mu = mu;
        this.sigma = sigma;
        if (sigma <= 0.0) {
            throw new RuntimeException("Sigma must be positive");
        }
    }

    @Override
    public double density(double x, boolean log) {
        return Normal.density(x, this.mu, this.sigma, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Normal.cumulative(p, this.mu, this.sigma, lower_tail, log_p);
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Normal.quantile(q, this.mu, this.sigma, lower_tail, log_p);
    }

    @Override
    public double random() {
        return Normal.random(this.mu, this.sigma, this.random);
    }
}

