/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Normal;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Levy
extends GenericDistribution {
    public double mu;
    public double sigma;

    public static final double density(double x, double mu, double sigma, boolean give_log) {
        double ld = 0.5 * Math.log(sigma / (Math.PI * 2)) - 1.5 * Math.log(x - mu) - 0.5 * sigma / (x - mu);
        return give_log ? ld : Math.exp(ld);
    }

    public static final double cumulative_standard(double x) {
        return Levy.cumulative(x, 0.0, 1.0, true, false);
    }

    public static final double cumulative(double x, double mu, double sigma) {
        return Levy.cumulative(x, mu, sigma, true, false);
    }

    public static final double cumulative(double x, double mu, double sigma, boolean lower_tail, boolean log_p) {
        double val = Normal.cumulative(Math.sqrt(sigma / (x - mu)), 0.0, 1.0, !lower_tail, log_p);
        return log_p ? Math.log(2.0) + val : 2.0 * val;
    }

    public static final double quantile(double p, double mu, double sigma, boolean lower_tail, boolean log_p) {
        if (log_p) {
            if (MathFunctions.isInfinite(p)) {
                return Double.POSITIVE_INFINITY;
            }
            if (p == 0.0) {
                return Double.NaN;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
        }
        double val = Normal.quantile(log_p ? p - Math.log(2.0) : p / 2.0, 0.0, 1.0, !lower_tail, log_p) / Math.sqrt(2.0);
        return mu + 0.5 * sigma / (val * val);
    }

    public static final double random(double mu, double sigma, RandomEngine random) {
        return mu + sigma * Levy.random_standard(random);
    }

    public static final double random_standard(RandomEngine random) {
        double u1 = random.nextDouble();
        u1 = (double)((int)(1.34217728E8 * u1)) + random.nextDouble();
        u1 = Levy.quantile(u1 / 1.34217728E8, 0.0, 1.0, true, false);
        return u1;
    }

    public static final double[] random(int n, double mu, double sigma, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = Levy.random(mu, sigma, random);
            ++i;
        }
        return rand;
    }

    public Levy() {
        this(0.0, 1.0);
    }

    public Levy(double mu, double sigma) {
        this.mu = mu;
        this.sigma = sigma;
        if (sigma <= 0.0) {
            throw new RuntimeException("Sigma must be positive");
        }
    }

    @Override
    public double density(double x, boolean log) {
        return Levy.density(x, this.mu, this.sigma, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Levy.cumulative(p, this.mu, this.sigma, lower_tail, log_p);
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Levy.quantile(q, this.mu, this.sigma, lower_tail, log_p);
    }

    @Override
    public double random() {
        return Levy.random(this.mu, this.sigma, this.random);
    }
}

