/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Kumaraswamy
extends GenericDistribution {
    protected double a;
    protected double b;

    public static final double density(double x, double a, double b, boolean give_log) {
        if (a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        if (x < 0.0 || x > 1.0) {
            return 0.0;
        }
        x = Math.log(a) + Math.log(b) + (a - 1.0) * Math.log(x) + (b - 1.0) * Math.log1p(-Math.pow(x, a));
        return give_log ? x : Math.exp(x);
    }

    public static final double cumulative(double x, double a, double b, boolean lower_tail, boolean log_p) {
        if (a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return 0.0;
        }
        if (x > 1.0) {
            return 1.0;
        }
        x = b * Math.log1p(-Math.pow(x, a));
        return log_p ? (lower_tail ? MathFunctions.logspace_sub(0.0, x) : x) : (lower_tail ? 1.0 - Math.exp(x) : x);
    }

    public static final double quantile(double p, double a, double b, boolean lower_tail, boolean log_p) {
        if (a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 1 : 0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return !lower_tail ? 1 : 0;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return !lower_tail ? 1 : 0;
            }
            if (p == 1.0) {
                return lower_tail ? 1 : 0;
            }
        }
        if (log_p) {
            p = Math.exp(p);
        }
        return !lower_tail ? Math.pow(1.0 - Math.pow(1.0 - p, 1.0 / b), 1.0 / a) : Math.pow(1.0 - Math.pow(p, 1.0 / b), 1.0 / a);
    }

    public static final double random(double a, double b, RandomEngine random) {
        if (a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        double u1 = random.nextDouble();
        u1 = (double)((int)(1.34217728E8 * u1)) + random.nextDouble();
        u1 = Math.pow(1.0 - Math.pow(u1 / 1.34217728E8, 1.0 / b), 1.0 / a);
        return u1;
    }

    public static final double[] random(int n, double a, double b, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = Kumaraswamy.random(a, b, random);
            ++i;
        }
        return rand;
    }

    public Kumaraswamy(double a, double b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public double density(double x, boolean log) {
        return Kumaraswamy.density((int)x, this.a, this.b, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Kumaraswamy.cumulative((int)p, this.a, this.b, lower_tail, log_p);
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Kumaraswamy.quantile(q, this.a, this.b, lower_tail, log_p);
    }

    @Override
    public double random() {
        return Kumaraswamy.random(this.a, this.b, this.random);
    }
}

