/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Binomial;
import jdistlib.Exponential;
import jdistlib.Poisson;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Geometric
extends GenericDistribution {
    protected double p;

    public static final double density(double x, double p, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(p)) {
            return x + p;
        }
        if (p <= 0.0 || p > 1.0) {
            return Double.NaN;
        }
        if (MathFunctions.isNonInt(x)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x < 0.0 || MathFunctions.isInfinite(x) || p == 0.0) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        x = Math.rint(x);
        double prob = Binomial.density_raw(0.0, x, p, 1.0 - p, give_log);
        return give_log ? Math.log(p) + prob : p * prob;
    }

    public static final double cumulative(double x, double p, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(p)) {
            return x + p;
        }
        if (p <= 0.0 || p > 1.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (MathFunctions.isInfinite(x)) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        x = Math.floor(x + 1.0E-7);
        if (p == 1.0) {
            x = lower_tail ? 1 : 0;
            return log_p ? Math.log(x) : x;
        }
        x = Math.log1p(-p) * (x + 1.0);
        if (log_p) {
            return lower_tail ? (log_p ? (x > -0.6931471805599453 ? Math.log(-Math.expm1(x)) : Math.log1p(-Math.exp(x))) : Math.log1p(-x)) : (log_p ? x : Math.log(x));
        }
        return lower_tail ? -Math.expm1(x) : Math.exp(x);
    }

    public static final double quantile(double p, double prob, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(p) || Double.isNaN(prob)) {
            return p + prob;
        }
        if (prob <= 0.0 || prob > 1.0) {
            return Double.NaN;
        }
        if (log_p && p > 0.0 || !log_p && (p < 0.0 || p > 1.0)) {
            return Double.NaN;
        }
        if (prob == 1.0) {
            return 0.0;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
        }
        p = lower_tail ? (log_p ? (p > -0.6931471805599453 ? Math.log(-Math.expm1(p)) : Math.log1p(-Math.exp(p))) : Math.log1p(-p)) : (log_p ? p : Math.log(p));
        return Math.max(0.0, Math.ceil(p / Math.log1p(-prob) - 1.0 - 1.0E-12));
    }

    public static final double random(double p, RandomEngine random) {
        if (MathFunctions.isInfinite(p) || p <= 0.0 || p > 1.0) {
            return Double.NaN;
        }
        return Poisson.random(Exponential.random_standard(random) * ((1.0 - p) / p), random);
    }

    public static final double[] random(int n, double p, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = Geometric.random(p, random);
            ++i;
        }
        return rand;
    }

    public Geometric(double p) {
        this.p = p;
    }

    @Override
    public double density(double x, boolean log) {
        return Geometric.density(x, this.p, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Geometric.cumulative(p, this.p, lower_tail, log_p);
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Geometric.quantile(q, this.p, lower_tail, log_p);
    }

    @Override
    public double random() {
        return Geometric.random(this.p, this.random);
    }
}

