/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Gamma;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Chi
extends GenericDistribution {
    protected double df;

    public static final double density(double x, double df, boolean give_log) {
        return Gamma.density(Math.sqrt(x), df / 2.0, 2.0, give_log);
    }

    public static final double cumulative(double x, double df, boolean lower_tail, boolean log_p) {
        return Gamma.cumulative(Math.sqrt(x), df / 2.0, 2.0, lower_tail, log_p);
    }

    public static final double quantile(double p, double df, boolean lower_tail, boolean log_p) {
        return Math.sqrt(Gamma.quantile(p, 0.5 * df, 2.0, lower_tail, log_p));
    }

    public static final double random(double df, RandomEngine random) {
        if (MathFunctions.isInfinite(df) || df < 0.0) {
            return Double.NaN;
        }
        return Math.sqrt(Gamma.random(df / 2.0, 2.0, random));
    }

    public static final double[] random(int n, double df, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = Chi.random(df, random);
            ++i;
        }
        return rand;
    }

    public Chi(double df) {
        this.df = df;
    }

    @Override
    public double density(double x, boolean log) {
        return Chi.density(x, this.df, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Chi.cumulative(p, this.df, lower_tail, log_p);
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Chi.quantile(q, this.df, lower_tail, log_p);
    }

    @Override
    public double random() {
        return Chi.random(this.df, this.random);
    }
}

