/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.unit;

public enum UnitType {
    METER(10),
    MILLIMETER(11),
    MICROMETER(12),
    INCH(13),
    FOOT(14),
    NANOMETER(15),
    UNITLESS(20),
    PARTS_PER_MILLION_WRT_ONE(21),
    PARTS_PER_MILLION_WRT_ZERO(22),
    PERCENT(23),
    RADIAN(30),
    DEGREE(31),
    GRADIAN(32),
    MILLIRADIAN(33),
    ARCSECOND(34),
    MILLIGRADIAN(35),
    MIL6400(36),
    DEGREE_SEXAGESIMAL(37),
    DEGREE_CELSIUS(50),
    KELVIN(51),
    DEGREE_FAHRENHEIT(52),
    PASCAL(60),
    HECTOPASCAL(61),
    KILOPASCAL(62),
    BAR(63),
    MILLIBAR(64),
    TORR(65);

    private int id;

    private UnitType(int id) {
        this.id = id;
    }

    public final int getId() {
        return this.id;
    }

    public static UnitType getEnumByValue(int value) {
        UnitType[] unitTypeArray = UnitType.values();
        int n = unitTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            UnitType element = unitTypeArray[n2];
            if (element.id == value) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

