/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.unit;

import java.util.Locale;
import org.applied_geodesy.util.i18n.I18N;
import org.applied_geodesy.util.unit.UnitType;

public abstract class Unit {
    final I18N i18n = new I18N(Locale.getDefault(), "i18n/units");
    final UnitType type;
    String abbreviation;
    String name;

    Unit(UnitType type) {
        this.type = type;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + " [" + this.abbreviation + "]";
    }

    public UnitType getType() {
        return this.type;
    }

    public String toFormattedAbbreviation() {
        return this.abbreviation.isBlank() ? "" : String.format(Locale.ENGLISH, this.i18n.getString("Unit.abbreviation.format", "in %s"), this.abbreviation);
    }
}

