/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.unit;

import java.util.LinkedHashMap;
import java.util.Map;
import org.applied_geodesy.util.unit.Unit;
import org.applied_geodesy.util.unit.UnitType;

public class TemperatureUnit
extends Unit {
    public static TemperatureUnit DEGREE_CELSIUS = new TemperatureUnit(UnitType.DEGREE_CELSIUS);
    public static TemperatureUnit KELVIN = new TemperatureUnit(UnitType.KELVIN);
    public static TemperatureUnit DEGREE_FAHRENHEIT = new TemperatureUnit(UnitType.DEGREE_FAHRENHEIT);
    public static final Map<UnitType, TemperatureUnit> UNITS = new LinkedHashMap<UnitType, TemperatureUnit>();
    private double zeroPointOffsetToDegreeCelsius = 0.0;
    private double conversionFactorToDegreeCelsius = 1.0;

    static {
        UNITS.put(UnitType.DEGREE_CELSIUS, DEGREE_CELSIUS);
        UNITS.put(UnitType.KELVIN, KELVIN);
        UNITS.put(UnitType.DEGREE_FAHRENHEIT, DEGREE_FAHRENHEIT);
    }

    private TemperatureUnit(UnitType type) {
        super(type);
        switch (type) {
            case DEGREE_CELSIUS: {
                this.name = this.i18n.getString("Unit.degree_celsius.name", "Degree Celsius");
                this.abbreviation = this.i18n.getString("Unit.degree_celsius.abbreviation", "\u2103");
                this.zeroPointOffsetToDegreeCelsius = 0.0;
                this.conversionFactorToDegreeCelsius = 1.0;
                break;
            }
            case DEGREE_FAHRENHEIT: {
                this.name = this.i18n.getString("Unit.degree_fahrenheit.name", "Degree Fahrenheit");
                this.abbreviation = this.i18n.getString("Unit.degree_fahrenheit.abbreviation", "\u2109");
                this.zeroPointOffsetToDegreeCelsius = 32.0;
                this.conversionFactorToDegreeCelsius = 0.5555555555555556;
                break;
            }
            case KELVIN: {
                this.name = this.i18n.getString("Unit.kelvin.name", "Kelvin");
                this.abbreviation = this.i18n.getString("Unit.kelvin.abbreviation", "K");
                this.zeroPointOffsetToDegreeCelsius = 273.15;
                this.conversionFactorToDegreeCelsius = 1.0;
                break;
            }
        }
    }

    public final double toDegreeCelsius(double d) {
        return (d - this.zeroPointOffsetToDegreeCelsius) * this.conversionFactorToDegreeCelsius;
    }

    public final double fromDegreeCelsius(double d) {
        return d / this.conversionFactorToDegreeCelsius + this.zeroPointOffsetToDegreeCelsius;
    }

    public static TemperatureUnit getUnit(UnitType type) {
        return UNITS.get((Object)type);
    }
}

