/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.unit;

import java.util.LinkedHashMap;
import java.util.Map;
import org.applied_geodesy.util.unit.Unit;
import org.applied_geodesy.util.unit.UnitType;

public class ScaleUnit
extends Unit {
    public static ScaleUnit UNITLESS = new ScaleUnit(UnitType.UNITLESS);
    public static ScaleUnit PARTS_PER_MILLION_WRT_ZERO = new ScaleUnit(UnitType.PARTS_PER_MILLION_WRT_ZERO);
    public static ScaleUnit PARTS_PER_MILLION_WRT_ONE = new ScaleUnit(UnitType.PARTS_PER_MILLION_WRT_ONE);
    public static final Map<UnitType, ScaleUnit> UNITS = new LinkedHashMap<UnitType, ScaleUnit>();
    private double a = 0.0;
    private double s = 1.0;

    static {
        UNITS.put(UnitType.UNITLESS, UNITLESS);
        UNITS.put(UnitType.PARTS_PER_MILLION_WRT_ZERO, PARTS_PER_MILLION_WRT_ZERO);
        UNITS.put(UnitType.PARTS_PER_MILLION_WRT_ONE, PARTS_PER_MILLION_WRT_ONE);
    }

    private ScaleUnit(UnitType type) {
        super(type);
        switch (type) {
            case UNITLESS: {
                this.name = this.i18n.getString("Unit.unitless.name", "Unitless");
                this.abbreviation = this.i18n.getString("Unit.unitless.abbreviation", "");
                this.a = 0.0;
                this.s = 1.0;
                break;
            }
            case PARTS_PER_MILLION_WRT_ZERO: {
                this.name = this.i18n.getString("Unit.ppm.one.name", "Parts per million");
                this.abbreviation = this.i18n.getString("Unit.ppm.one.abbreviation", "ppm");
                this.a = 0.0;
                this.s = 1.0E-6;
                break;
            }
            case PARTS_PER_MILLION_WRT_ONE: {
                this.name = this.i18n.getString("Unit.ppm.zero.name", "Parts per million");
                this.abbreviation = this.i18n.getString("Unit.ppm.zero.abbreviation", "ppm");
                this.a = 1.0;
                this.s = 1.0E-6;
                break;
            }
        }
    }

    public final double toUnitless(double d) {
        return this.a + d * this.s;
    }

    public final double fromUnitless(double d) {
        return (d - this.a) / this.s;
    }

    public static ScaleUnit getUnit(UnitType type) {
        return UNITS.get((Object)type);
    }
}

