/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.unit;

import java.util.LinkedHashMap;
import java.util.Map;
import org.applied_geodesy.util.unit.Unit;
import org.applied_geodesy.util.unit.UnitType;

public class PressureUnit
extends Unit {
    public static PressureUnit PASCAL = new PressureUnit(UnitType.PASCAL);
    public static PressureUnit HECTOPASCAL = new PressureUnit(UnitType.HECTOPASCAL);
    public static PressureUnit KILOPASCAL = new PressureUnit(UnitType.KILOPASCAL);
    public static PressureUnit BAR = new PressureUnit(UnitType.BAR);
    public static PressureUnit MILLIBAR = new PressureUnit(UnitType.MILLIBAR);
    public static PressureUnit TORR = new PressureUnit(UnitType.TORR);
    public static final Map<UnitType, PressureUnit> UNITS = new LinkedHashMap<UnitType, PressureUnit>();
    private double conversionFactorToHectopascal = 1.0;

    static {
        UNITS.put(UnitType.PASCAL, PASCAL);
        UNITS.put(UnitType.HECTOPASCAL, HECTOPASCAL);
        UNITS.put(UnitType.KILOPASCAL, KILOPASCAL);
        UNITS.put(UnitType.BAR, BAR);
        UNITS.put(UnitType.MILLIBAR, MILLIBAR);
        UNITS.put(UnitType.TORR, TORR);
    }

    private PressureUnit(UnitType type) {
        super(type);
        switch (type) {
            case PASCAL: {
                this.name = this.i18n.getString("Unit.pascal.name", "Pascal");
                this.abbreviation = this.i18n.getString("Unit.pascal.abbreviation", "Pa");
                this.conversionFactorToHectopascal = 100.0;
                break;
            }
            case KILOPASCAL: {
                this.name = this.i18n.getString("Unit.kilopascal.name", "Kilopascal");
                this.abbreviation = this.i18n.getString("Unit.kilopascal.abbreviation", "kPa");
                this.conversionFactorToHectopascal = 0.1;
                break;
            }
            case HECTOPASCAL: {
                this.name = this.i18n.getString("Unit.hectopascal.name", "Hectopascal");
                this.abbreviation = this.i18n.getString("Unit.hectopascal.abbreviation", "hPa");
                this.conversionFactorToHectopascal = 1.0;
                break;
            }
            case BAR: {
                this.name = this.i18n.getString("Unit.bar.name", "Bar");
                this.abbreviation = this.i18n.getString("Unit.bar.abbreviation", "bar");
                this.conversionFactorToHectopascal = 1000.0;
                break;
            }
            case MILLIBAR: {
                this.name = this.i18n.getString("Unit.millibar.name", "Millibar");
                this.abbreviation = this.i18n.getString("Unit.millibar.abbreviation", "mbar");
                this.conversionFactorToHectopascal = 1.0;
                break;
            }
            case TORR: {
                this.name = this.i18n.getString("Unit.torr.name", "Torr");
                this.abbreviation = this.i18n.getString("Unit.torr.abbreviation", "Torr");
                this.conversionFactorToHectopascal = 1.3332236842105263;
                break;
            }
        }
    }

    public final double toHectopascal(double d) {
        return d * this.conversionFactorToHectopascal;
    }

    public final double fromHectopascal(double d) {
        return d / this.conversionFactorToHectopascal;
    }

    public static PressureUnit getUnit(UnitType type) {
        return UNITS.get((Object)type);
    }
}

