/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.unit;

import java.util.LinkedHashMap;
import java.util.Map;
import org.applied_geodesy.util.unit.Unit;
import org.applied_geodesy.util.unit.UnitType;

public class PercentUnit
extends Unit {
    public static PercentUnit UNITLESS = new PercentUnit(UnitType.UNITLESS);
    public static PercentUnit PERCENT = new PercentUnit(UnitType.PERCENT);
    public static final Map<UnitType, PercentUnit> UNITS = new LinkedHashMap<UnitType, PercentUnit>();
    private double conversionFactorToUnitless = 1.0;

    static {
        UNITS.put(UnitType.UNITLESS, UNITLESS);
        UNITS.put(UnitType.PERCENT, PERCENT);
    }

    private PercentUnit(UnitType type) {
        super(type);
        switch (type) {
            case UNITLESS: {
                this.name = this.i18n.getString("Unit.unitless.name", "Unitless");
                this.abbreviation = this.i18n.getString("Unit.unitless.abbreviation", "\u2014");
                this.conversionFactorToUnitless = 1.0;
                break;
            }
            case PERCENT: {
                this.name = this.i18n.getString("Unit.percent.name", "Percent");
                this.abbreviation = this.i18n.getString("Unit.percent.abbreviation", "%");
                this.conversionFactorToUnitless = 0.01;
                break;
            }
        }
    }

    public final double toUnitless(double d) {
        return d * this.conversionFactorToUnitless;
    }

    public final double fromUnitless(double d) {
        return d / this.conversionFactorToUnitless;
    }

    public static PercentUnit getUnit(UnitType type) {
        return UNITS.get((Object)type);
    }
}

