/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.unit;

import java.util.LinkedHashMap;
import java.util.Map;
import org.applied_geodesy.util.unit.Unit;
import org.applied_geodesy.util.unit.UnitType;

public class LengthUnit
extends Unit {
    public static LengthUnit METER = new LengthUnit(UnitType.METER);
    public static LengthUnit MILLIMETER = new LengthUnit(UnitType.MILLIMETER);
    public static LengthUnit MICROMETER = new LengthUnit(UnitType.MICROMETER);
    public static LengthUnit NANOMETER = new LengthUnit(UnitType.NANOMETER);
    public static LengthUnit INCH = new LengthUnit(UnitType.INCH);
    public static LengthUnit FOOT = new LengthUnit(UnitType.FOOT);
    public static final Map<UnitType, LengthUnit> UNITS = new LinkedHashMap<UnitType, LengthUnit>();
    private double conversionFactorToMeter = 1.0;

    static {
        UNITS.put(UnitType.METER, METER);
        UNITS.put(UnitType.MILLIMETER, MILLIMETER);
        UNITS.put(UnitType.MICROMETER, MICROMETER);
        UNITS.put(UnitType.NANOMETER, NANOMETER);
        UNITS.put(UnitType.INCH, INCH);
        UNITS.put(UnitType.FOOT, FOOT);
    }

    private LengthUnit(UnitType type) {
        super(type);
        switch (type) {
            case METER: {
                this.name = this.i18n.getString("Unit.meter.name", "Meter");
                this.abbreviation = this.i18n.getString("Unit.meter.abbreviation", "m");
                this.conversionFactorToMeter = 1.0;
                break;
            }
            case MILLIMETER: {
                this.name = this.i18n.getString("Unit.millimeter.name", "Millimeter");
                this.abbreviation = this.i18n.getString("Unit.millimeter.abbreviation", "mm");
                this.conversionFactorToMeter = 0.001;
                break;
            }
            case MICROMETER: {
                this.name = this.i18n.getString("Unit.micrometer.name", "Micrometer");
                this.abbreviation = this.i18n.getString("Unit.micrometer.abbreviation", "\u03bcm");
                this.conversionFactorToMeter = 1.0E-6;
                break;
            }
            case NANOMETER: {
                this.name = this.i18n.getString("Unit.nanometer.name", "Nanometer");
                this.abbreviation = this.i18n.getString("Unit.nanometer.abbreviation", "nm");
                this.conversionFactorToMeter = 1.0E-9;
                break;
            }
            case INCH: {
                this.name = this.i18n.getString("Unit.inch.name", "Inch");
                this.abbreviation = this.i18n.getString("Unit.inch.abbreviation", "in");
                this.conversionFactorToMeter = 0.0254;
                break;
            }
            case FOOT: {
                this.name = this.i18n.getString("Unit.foot.name", "Foot");
                this.abbreviation = this.i18n.getString("Unit.foot.abbreviation", "ft");
                this.conversionFactorToMeter = 0.3048;
                break;
            }
        }
    }

    public final double toMeter(double d) {
        return d * this.conversionFactorToMeter;
    }

    public final double fromMeter(double d) {
        return d / this.conversionFactorToMeter;
    }

    public static LengthUnit getUnit(UnitType type) {
        return UNITS.get((Object)type);
    }
}

