/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.unit;

import java.util.LinkedHashMap;
import java.util.Map;
import org.applied_geodesy.util.unit.Unit;
import org.applied_geodesy.util.unit.UnitType;

public class AngleUnit
extends Unit {
    public static AngleUnit RADIAN = new AngleUnit(UnitType.RADIAN);
    public static AngleUnit DEGREE = new AngleUnit(UnitType.DEGREE);
    public static AngleUnit DEGREE_SEXAGESIMAL = new AngleUnit(UnitType.DEGREE_SEXAGESIMAL);
    public static AngleUnit GRADIAN = new AngleUnit(UnitType.GRADIAN);
    public static AngleUnit MILLIRADIAN = new AngleUnit(UnitType.MILLIRADIAN);
    public static AngleUnit ARCSECOND = new AngleUnit(UnitType.ARCSECOND);
    public static AngleUnit MILLIGRADIAN = new AngleUnit(UnitType.MILLIGRADIAN);
    public static AngleUnit MIL6400 = new AngleUnit(UnitType.MIL6400);
    public static final Map<UnitType, AngleUnit> UNITS = new LinkedHashMap<UnitType, AngleUnit>();
    private double conversionFactorToRadian = 1.0;

    static {
        UNITS.put(UnitType.RADIAN, RADIAN);
        UNITS.put(UnitType.GRADIAN, GRADIAN);
        UNITS.put(UnitType.DEGREE, DEGREE);
        UNITS.put(UnitType.DEGREE_SEXAGESIMAL, DEGREE_SEXAGESIMAL);
        UNITS.put(UnitType.MILLIRADIAN, MILLIRADIAN);
        UNITS.put(UnitType.MILLIGRADIAN, MILLIGRADIAN);
        UNITS.put(UnitType.ARCSECOND, ARCSECOND);
        UNITS.put(UnitType.MIL6400, MIL6400);
    }

    private AngleUnit(UnitType type) {
        super(type);
        switch (type) {
            case RADIAN: {
                this.name = this.i18n.getString("Unit.radian.name", "Radian");
                this.abbreviation = this.i18n.getString("Unit.radian.abbreviation", "rad");
                this.conversionFactorToRadian = 1.0;
                break;
            }
            case DEGREE: {
                this.name = this.i18n.getString("Unit.degree.name", "Degree");
                this.abbreviation = this.i18n.getString("Unit.degree.abbreviation", "\u00b0");
                this.conversionFactorToRadian = Math.PI / 180;
                break;
            }
            case DEGREE_SEXAGESIMAL: {
                this.name = this.i18n.getString("Unit.degree_sexagesimal.name", "Sexagesimal degree");
                this.abbreviation = this.i18n.getString("Unit.degree_sexagesimal.abbreviation", "\u00b0 \u2032 \u2033");
                this.conversionFactorToRadian = Math.PI / 180;
                break;
            }
            case GRADIAN: {
                this.name = this.i18n.getString("Unit.gradian.name", "Gradian");
                this.abbreviation = this.i18n.getString("Unit.gradian.abbreviation", "gon");
                this.conversionFactorToRadian = 0.015707963267948967;
                break;
            }
            case MILLIRADIAN: {
                this.name = this.i18n.getString("Unit.milliradian.name", "Milliradian");
                this.abbreviation = this.i18n.getString("Unit.milliradian.abbreviation", "mrad");
                this.conversionFactorToRadian = 0.001;
                break;
            }
            case ARCSECOND: {
                this.name = this.i18n.getString("Unit.arcsecond.name", "Arcsecond");
                this.abbreviation = this.i18n.getString("Unit.arcsecond.abbreviation", "\u2033");
                this.conversionFactorToRadian = 4.84813681109536E-6;
                break;
            }
            case MILLIGRADIAN: {
                this.name = this.i18n.getString("Unit.milligradian.name", "Milligradian");
                this.abbreviation = this.i18n.getString("Unit.milligradian.abbreviation", "mgon");
                this.conversionFactorToRadian = 1.5707963267948967E-5;
                break;
            }
            case MIL6400: {
                this.name = this.i18n.getString("Unit.mil6400.name", "Mil");
                this.abbreviation = this.i18n.getString("Unit.mil6400.abbreviation", "\u00af");
                this.conversionFactorToRadian = 9.817477042468104E-4;
                break;
            }
        }
    }

    public final double toRadian(double d) {
        return d * this.conversionFactorToRadian;
    }

    public final double fromRadian(double d) {
        return d / this.conversionFactorToRadian;
    }

    public static AngleUnit getUnit(UnitType type) {
        return UNITS.get((Object)type);
    }
}

