/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.applied_geodesy.util.sql.DataBase;

public class HSQLDB
extends DataBase {
    private static final String SQL_LAST_ID = "CALL IDENTITY()";
    public static final String JDBCDriver = "org.hsqldb.jdbcDriver";
    private final String dbFileName;

    public HSQLDB(String dbFileName) {
        this(dbFileName, "sa", "");
    }

    public HSQLDB(String dbFileName, String username, String password) {
        super(JDBCDriver, username, password);
        this.dbFileName = dbFileName;
    }

    @Override
    public String getURI() {
        return "jdbc:hsqldb:file:" + this.dbFileName + ";shutdown=true";
    }

    @Override
    public void close() {
        block12: {
            if (this.isOpen()) {
                try {
                    try {
                        this.getPreparedStatement("CHECKPOINT DEFRAG").execute();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        try {
                            this.getPreparedStatement("SHUTDOWN COMPACT").execute();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.getPreparedStatement("SHUTDOWN COMPACT").execute();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    this.getPreparedStatement("SHUTDOWN COMPACT").execute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        super.close();
    }

    public String getDataBaseFileName() {
        return this.dbFileName;
    }

    @Override
    public int getLastInsertId() throws SQLException {
        PreparedStatement statementId = this.getPreparedStatement(SQL_LAST_ID);
        ResultSet lastId = statementId.executeQuery();
        if (lastId.next() && !lastId.wasNull()) {
            return lastId.getInt(1);
        }
        return -1;
    }
}

