/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.sql;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;

public abstract class DataBase {
    private final String dbDriver;
    private final String username;
    private final String password;
    private Connection conn = null;
    private boolean isOpen = false;

    public DataBase(String dbDriver, String username, String password) {
        this.dbDriver = dbDriver;
        this.username = username;
        this.password = password;
    }

    public abstract String getURI();

    public final String getDBDriver() {
        return this.dbDriver;
    }

    public void open() throws ClassNotFoundException, SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            this.conn = this.createConnection();
            this.isOpen = true;
        }
    }

    public boolean isOpen() {
        try {
            return this.conn != null && !this.conn.isClosed() && this.isOpen;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void close() {
        if (this.conn == null) {
            return;
        }
        try {
            if (this.conn.isClosed()) {
                return;
            }
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.conn = null;
            this.isOpen = false;
        }
    }

    public abstract int getLastInsertId() throws SQLException;

    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        if (this.isOpen()) {
            return this.conn.prepareStatement(sql);
        }
        return null;
    }

    public Statement getStatement() throws SQLException {
        if (this.isOpen()) {
            return this.conn.createStatement();
        }
        return null;
    }

    public void commit() throws SQLException {
        if (this.isOpen()) {
            this.conn.commit();
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.isOpen()) {
            this.conn.setAutoCommit(autoCommit);
        }
    }

    public boolean isAutoCommit() throws SQLException {
        if (this.isOpen()) {
            return this.conn.getAutoCommit();
        }
        return false;
    }

    public void rollback() throws SQLException {
        if (this.isOpen()) {
            this.conn.rollback();
        }
    }

    private Connection createConnection() throws ClassNotFoundException, SQLException {
        Class.forName(this.getDBDriver());
        Connection con = DriverManager.getConnection(this.getURI(), this.username, this.password);
        return con;
    }

    Connection getConnection() {
        return this.conn;
    }

    public void executeFiles(List<File> files) throws SQLException, IOException {
        boolean autoCommit = true;
        try {
            try {
                autoCommit = this.isAutoCommit();
                this.setAutoCommit(false);
                Map sqlVarMap = new HashMap();
                for (File file : files) {
                    if (!file.isFile()) {
                        throw new IOException("Error, selected SQL file is not present, " + file.getAbsolutePath() + "!");
                    }
                    SqlFile sqlFile = new SqlFile(file);
                    sqlFile.setConnection(this.conn);
                    sqlFile.addUserVars(sqlVarMap);
                    sqlFile.execute();
                    this.conn = sqlFile.getConnection();
                    sqlVarMap = sqlFile.getUserVars();
                }
            }
            catch (SQLException | SqlToolError e) {
                e.printStackTrace();
                this.rollback();
                throw new SQLException(e);
            }
        }
        finally {
            this.setAutoCommit(autoCommit);
        }
    }
}

