/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.io.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLNamespaceContext
implements NamespaceContext {
    private final String defaultPrefix;
    private Map<String, String> prefix2Uri = new HashMap<String, String>();
    private Map<String, LinkedHashSet<String>> uri2Prefix = new HashMap<String, LinkedHashSet<String>>();

    public XMLNamespaceContext(Document document) {
        this(document, Boolean.FALSE);
    }

    public XMLNamespaceContext(Document document, boolean topLevelOnly) {
        this(document, "", "", topLevelOnly);
    }

    public XMLNamespaceContext(Document document, String defaultPrefix, String defaultURI) {
        this(document, defaultPrefix, defaultURI, (boolean)Boolean.FALSE);
    }

    public XMLNamespaceContext(Document document, String[] defaultPrefixes, String[] defaultURIs) {
        this(document, defaultPrefixes, defaultURIs, (boolean)Boolean.FALSE);
    }

    public XMLNamespaceContext(Document document, String defaultPrefix, String defaultURI, boolean topLevelOnly) {
        this(document, new String[]{defaultPrefix}, new String[]{defaultURI}, (boolean)Boolean.FALSE);
    }

    public XMLNamespaceContext(Document document, String[] defaultPrefixes, String[] defaultURIs, boolean topLevelOnly) {
        this.defaultPrefix = defaultPrefixes == null || defaultPrefixes.length == 0 ? "" : defaultPrefixes[0];
        int i = 0;
        while (i < defaultPrefixes.length) {
            this.putInCache(defaultPrefixes[i] == null ? "" : defaultPrefixes[i], defaultURIs[i] == null ? "" : defaultURIs[i]);
            ++i;
        }
        this.examineNode(document.getFirstChild(), topLevelOnly);
    }

    private void examineNode(Node node, boolean attributesOnly) {
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            this.storeAttribute((Attr)attribute);
            ++i;
        }
        if (!attributesOnly) {
            NodeList chields = node.getChildNodes();
            int i2 = 0;
            while (i2 < chields.getLength()) {
                Node chield = chields.item(i2);
                if (chield.getNodeType() == 1) {
                    this.examineNode(chield, false);
                }
                ++i2;
            }
        }
    }

    private void storeAttribute(Attr attribute) {
        if (attribute.getNamespaceURI() != null && attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
            if (attribute.getNodeName().equals("xmlns")) {
                String prefix = this.getPrefix(attribute);
                this.putInCache(prefix, attribute.getNodeValue());
            } else {
                this.putInCache(attribute.getLocalName(), attribute.getNodeValue());
            }
        }
    }

    public abstract String getPrefix(Attr var1);

    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    private void putInCache(String prefix, String uri) {
        this.prefix2Uri.put(prefix, uri);
        if (!this.uri2Prefix.containsKey(uri)) {
            this.uri2Prefix.put(uri, new LinkedHashSet(5));
        }
        LinkedHashSet<String> ps = this.uri2Prefix.get(uri);
        ps.add(prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if ((prefix == null || prefix.equals("")) && this.prefix2Uri.containsKey(this.defaultPrefix)) {
            return this.prefix2Uri.get(this.defaultPrefix);
        }
        if (this.prefix2Uri.containsKey(prefix)) {
            return this.prefix2Uri.get(prefix);
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        Iterator iterator = this.uri2Prefix.get(namespaceURI).iterator();
        if (iterator.hasNext()) {
            String prefix = (String)iterator.next();
            return prefix;
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return this.uri2Prefix.containsKey(namespaceURI) ? this.uri2Prefix.get(namespaceURI).iterator() : Collections.emptyIterator();
    }
}

