/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.io.properties;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Properties;
import org.applied_geodesy.util.io.properties.URLParameter;

public class HTTPPropertiesLoader {
    static {
        BufferedInputStream bis = null;
        String path = "properties/proxy.default";
        try {
            try {
                if (HTTPPropertiesLoader.class.getClassLoader().getResourceAsStream("properties/proxy.default") != null) {
                    Properties properties = new Properties();
                    bis = new BufferedInputStream(HTTPPropertiesLoader.class.getClassLoader().getResourceAsStream("properties/proxy.default"));
                    properties.load(bis);
                    String host = properties.getProperty("HOST", null);
                    if (host != null && !host.trim().isEmpty()) {
                        String protocol = properties.getProperty("PROTOCOL", "HTTP").toLowerCase();
                        String port = properties.getProperty("PORT", "80");
                        String username = properties.getProperty("USERNAME", "");
                        String password = properties.getProperty("PASSWORD", "");
                        Properties systemSettings = System.getProperties();
                        systemSettings.put(protocol + ".proxyHost", host.trim());
                        systemSettings.put(protocol + ".proxyPort", port.trim());
                        systemSettings.put(protocol + ".proxyUser", username.trim());
                        systemSettings.put(protocol + ".proxyPassword", password.trim());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Properties getProperties(String address, URLParameter ... params) throws IOException, URISyntaxException {
        Properties properties = new Properties();
        BufferedReader bufferedReader = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                        String protocol = this.getRequestingProtocol().toLowerCase();
                        String host = System.getProperty(protocol + ".proxyHost", "");
                        String port = System.getProperty(protocol + ".proxyPort", "80");
                        String username = System.getProperty(protocol + ".proxyUser", "");
                        String password = System.getProperty(protocol + ".proxyPassword", "");
                        int portNumber = 80;
                        try {
                            portNumber = Integer.parseInt(port);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (this.getRequestingHost().equalsIgnoreCase(host) && portNumber == this.getRequestingPort()) {
                            return new PasswordAuthentication(username, password.toCharArray());
                        }
                    }
                    return null;
                }
            });
            Object data = "";
            URLParameter[] uRLParameterArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                URLParameter param = uRLParameterArray[n2];
                data = (String)data + URLEncoder.encode(((String)param.getKey()).trim(), "UTF-8") + "=" + URLEncoder.encode(((String)param.getValue()).trim(), "UTF-8");
                ++n2;
            }
            URL url = new URI(address).toURL();
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            outputStreamWriter = new OutputStreamWriter(conn.getOutputStream());
            outputStreamWriter.write((String)data);
            outputStreamWriter.flush();
            bufferedReader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            properties.load(bufferedReader);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (Exception exception) {}
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return properties;
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        String address = "https://software.applied-geodesy.org/update.php";
        URLParameter param = new URLParameter("checkupdate", "jag3d");
        Properties s = HTTPPropertiesLoader.getProperties(address, param);
        System.out.println(s);
    }
}

