/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.io.csv;

import java.io.IOException;
import java.util.ArrayList;

public class CSVParser {
    final char separator;
    final char quotechar;
    final char escape;
    final boolean strictQuotes;
    private String pending;
    private boolean inField = false;
    final boolean ignoreLeadingWhiteSpace;
    final boolean ignoreQuotations;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final int INITIAL_READ_SIZE = 128;
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char DEFAULT_ESCAPE_CHARACTER = '\\';
    public static final boolean DEFAULT_STRICT_QUOTES = false;
    public static final boolean DEFAULT_IGNORE_LEADING_WHITESPACE = true;
    public static final boolean DEFAULT_IGNORE_QUOTATIONS = false;
    public static final char NULL_CHARACTER = '\u0000';

    public CSVParser() {
        this(',', '\"', '\\');
    }

    public CSVParser(char separator) {
        this(separator, '\"', '\\');
    }

    public CSVParser(char separator, char quotechar) {
        this(separator, quotechar, '\\');
    }

    public CSVParser(char separator, char quotechar, char escape) {
        this(separator, quotechar, escape, false);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes) {
        this(separator, quotechar, escape, strictQuotes, true);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        this(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace, false);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, boolean ignoreQuotations) {
        if (this.anyCharactersAreTheSame(separator, quotechar, escape)) {
            throw new UnsupportedOperationException("The separator, quote, and escape characters must be different!");
        }
        if (separator == '\u0000') {
            throw new UnsupportedOperationException("The separator character must be defined!");
        }
        this.separator = separator;
        this.quotechar = quotechar;
        this.escape = escape;
        this.strictQuotes = strictQuotes;
        this.ignoreLeadingWhiteSpace = ignoreLeadingWhiteSpace;
        this.ignoreQuotations = ignoreQuotations;
    }

    private boolean anyCharactersAreTheSame(char separator, char quotechar, char escape) {
        return this.isSameCharacter(separator, quotechar) || this.isSameCharacter(separator, escape) || this.isSameCharacter(quotechar, escape);
    }

    private boolean isSameCharacter(char c1, char c2) {
        return c1 != '\u0000' && c1 == c2;
    }

    public boolean isPending() {
        return this.pending != null;
    }

    public String[] parseLineMulti(String nextLine) throws IOException {
        return this.parseLine(nextLine, true);
    }

    public String[] parseLine(String nextLine) throws IOException {
        return this.parseLine(nextLine, false);
    }

    private String[] parseLine(String nextLine, boolean multi) throws IOException {
        if (!multi && this.pending != null) {
            this.pending = null;
        }
        if (nextLine == null) {
            if (this.pending != null) {
                String s = this.pending;
                this.pending = null;
                return new String[]{s};
            }
            return null;
        }
        ArrayList<String> tokensOnThisLine = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(128);
        boolean inQuotes = false;
        if (this.pending != null) {
            sb.append(this.pending);
            this.pending = null;
            inQuotes = !this.ignoreQuotations;
        }
        int i = 0;
        while (i < nextLine.length()) {
            char c = nextLine.charAt(i);
            if (c == this.escape) {
                if (this.isNextCharacterEscapable(nextLine, inQuotes && !this.ignoreQuotations || this.inField, i)) {
                    sb.append(nextLine.charAt(i + 1));
                    ++i;
                }
            } else if (c == this.quotechar) {
                if (this.isNextCharacterEscapedQuote(nextLine, inQuotes && !this.ignoreQuotations || this.inField, i)) {
                    sb.append(nextLine.charAt(i + 1));
                    ++i;
                } else {
                    boolean bl = inQuotes = !inQuotes;
                    if (!this.strictQuotes && i > 2 && nextLine.charAt(i - 1) != this.separator && nextLine.length() > i + 1 && nextLine.charAt(i + 1) != this.separator) {
                        if (this.ignoreLeadingWhiteSpace && sb.length() > 0 && this.isAllWhiteSpace(sb)) {
                            sb = new StringBuilder(128);
                        } else {
                            sb.append(c);
                        }
                    }
                }
                this.inField = !this.inField;
            } else if (c == this.separator && (!inQuotes || this.ignoreQuotations)) {
                tokensOnThisLine.add(sb.toString());
                sb = new StringBuilder(128);
                this.inField = false;
            } else if (!this.strictQuotes || inQuotes && !this.ignoreQuotations) {
                sb.append(c);
                this.inField = true;
            }
            ++i;
        }
        if (inQuotes && !this.ignoreQuotations) {
            if (multi) {
                sb.append("\n");
                this.pending = sb.toString();
                sb = null;
            } else {
                throw new IOException("Un-terminated quoted field at end of CSV line");
            }
        }
        if (sb != null) {
            tokensOnThisLine.add(sb.toString());
        }
        return tokensOnThisLine.toArray(new String[tokensOnThisLine.size()]);
    }

    private boolean isNextCharacterEscapedQuote(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && nextLine.charAt(i + 1) == this.quotechar;
    }

    protected boolean isNextCharacterEscapable(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && (nextLine.charAt(i + 1) == this.quotechar || nextLine.charAt(i + 1) == this.escape);
    }

    protected boolean isAllWhiteSpace(CharSequence sb) {
        boolean result = true;
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (!Character.isWhitespace(c)) {
                return false;
            }
            ++i;
        }
        return result;
    }
}

