/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.io;

import java.io.File;
import java.nio.file.Path;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.util.io.LockFileReader;

public abstract class SourceFileReader<T>
extends LockFileReader {
    public static final double SQRT_EPS = Math.sqrt(Constant.EPS);

    protected SourceFileReader() {
    }

    protected SourceFileReader(String fileName) {
        this(new File(fileName).toPath());
    }

    protected SourceFileReader(File sf) {
        this(sf.toPath());
    }

    protected SourceFileReader(Path path) {
        super(path);
        this.setPath(path);
    }

    @Override
    public void setPath(Path path) {
        this.setPath(path, Boolean.TRUE);
    }

    public void setPath(Path path, boolean reset) {
        if (reset) {
            this.reset();
        }
        super.setPath(path);
    }

    public abstract T readAndImport() throws Exception;

    public abstract void reset();

    public String createItemName(String prefix, String suffix) {
        prefix = prefix == null ? "" : prefix;
        suffix = suffix == null ? "" : suffix;
        String fileName = this.getPath().getFileName().toString();
        if (!fileName.trim().isEmpty()) {
            if (fileName.indexOf(46) > 0) {
                fileName = fileName.substring(0, fileName.lastIndexOf(46));
            }
            return prefix + fileName + suffix;
        }
        return null;
    }
}

