/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.io;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.applied_geodesy.util.io.LockFileReader;

public class PreviewFileReader
extends LockFileReader {
    private static final int MAX_LINES = 15;
    private int maxLines = 15;
    private int lineCounter = 0;
    private List<String> lines = new ArrayList<String>();

    public PreviewFileReader(File sf) {
        this(sf, 15);
    }

    public PreviewFileReader(File sf, int maxLines) {
        super(sf);
        this.maxLines = maxLines;
    }

    public void reset() {
        this.lineCounter = 0;
        this.lines.clear();
    }

    @Override
    public void read() throws IOException, SQLException {
        this.reset();
        super.read();
    }

    @Override
    public void parse(String line) {
        if (this.lines.add(line)) {
            ++this.lineCounter;
        }
        if (this.lineCounter >= this.maxLines) {
            super.interrupt();
        }
    }

    public List<String> getLines() {
        return this.lines;
    }
}

