/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.applied_geodesy.util.io.FileProgressChangeListener;
import org.applied_geodesy.util.io.FileProgressEvent;

public abstract class LockFileReader {
    private Path sourceFilePath = null;
    private String ignoreStartString = new String();
    public static final String UTF8_BOM = "\ufeff";
    private boolean interrupt = false;
    private List<EventListener> listenerList = new ArrayList<EventListener>();

    LockFileReader() {
    }

    LockFileReader(String fileName) {
        this(new File(fileName).toPath());
    }

    LockFileReader(File sf) {
        this(sf.toPath());
    }

    LockFileReader(Path path) {
        this.setPath(path);
    }

    void setPath(Path path) {
        this.sourceFilePath = path;
    }

    public Path getPath() {
        return this.sourceFilePath;
    }

    public abstract void parse(String var1) throws SQLException;

    public void ignoreLinesWhichStartWith(String str) {
        this.ignoreStartString = str;
    }

    public void read() throws IOException, SQLException {
        if (!(this.sourceFilePath != null && Files.exists(this.sourceFilePath, new LinkOption[0]) && Files.isRegularFile(this.sourceFilePath, new LinkOption[0]) && Files.isReadable(this.sourceFilePath))) {
            return;
        }
        this.interrupt = false;
        BufferedReader reader = null;
        boolean isFirstLine = true;
        try {
            long totalBytes = Files.size(this.sourceFilePath);
            File sourceFile = this.sourceFilePath.toFile();
            FileInputStream inputStream = new FileInputStream(sourceFile);
            inputStream.getChannel().lock(0L, Long.MAX_VALUE, true);
            reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charset.forName("UTF-8")), 65536);
            long readedBytes = 0L;
            String currentLine = null;
            while (!this.interrupt && (currentLine = this.removeNonBMPCharacters(reader.readLine())) != null) {
                readedBytes += (long)currentLine.length();
                if (isFirstLine && currentLine.startsWith(UTF8_BOM)) {
                    currentLine = currentLine.substring(1);
                    isFirstLine = false;
                }
                if (!(currentLine.isBlank() || !this.ignoreStartString.isEmpty() && currentLine.startsWith(this.ignoreStartString))) {
                    this.parse(currentLine);
                }
                this.fireFileProgressChanged(sourceFile, FileProgressEvent.FileProgressEventType.READ_LINE, readedBytes, totalBytes);
            }
            this.fireFileProgressChanged(sourceFile, FileProgressEvent.FileProgressEventType.READ_LINE, totalBytes, totalBytes);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String removeNonBMPCharacters(String str) {
        if (str == null || str.isBlank()) {
            return str;
        }
        int len = str.length();
        StringBuilder stringBuilder = new StringBuilder(len);
        int offset = 0;
        while (offset < len) {
            int codePoint = str.codePointAt(offset);
            offset += Character.charCount(codePoint);
            if (Character.isIdentifierIgnorable(codePoint)) continue;
            stringBuilder.append(Character.toChars(codePoint));
        }
        return stringBuilder.toString();
    }

    public void interrupt() {
        this.interrupt = true;
    }

    public boolean isInterrupted() {
        return this.interrupt;
    }

    public void addFileProgressChangeListener(FileProgressChangeListener l) {
        this.listenerList.add(l);
    }

    public void removeFileProgressChangeListener(FileProgressChangeListener l) {
        this.listenerList.remove(l);
    }

    private void fireFileProgressChanged(File file, FileProgressEvent.FileProgressEventType eventType, long readedBytes, long totalBytes) {
        FileProgressEvent evt = new FileProgressEvent(file, eventType, Math.min(readedBytes, totalBytes), Math.max(readedBytes, totalBytes));
        Object[] listeners = this.listenerList.toArray();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof FileProgressChangeListener) {
                ((FileProgressChangeListener)listeners[i]).fileProgressChanged(evt);
            }
            ++i;
        }
    }
}

