/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util.i18n;

import java.util.Locale;
import java.util.ResourceBundle;

public class I18N {
    private ResourceBundle bundle;
    private Locale currentLocale = Locale.ENGLISH;
    private String baseName = null;

    public I18N(Locale locale, String baseName) {
        this.setLocale(locale);
        this.setBaseName(baseName);
    }

    public void setLocale(Locale locale) {
        this.currentLocale = locale;
        this.loadBundle();
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
        this.loadBundle();
    }

    public void loadBundle() {
        if (this.currentLocale != null && this.baseName != null) {
            try {
                ResourceBundle.clearCache();
                this.bundle = ResourceBundle.getBundle(this.baseName, this.currentLocale);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getString(String key, String defaultValue) {
        if (key == null || this.bundle == null || !this.bundle.containsKey(key)) {
            System.err.println(this.getClass().getSimpleName() + " WARNING: Missing entry in lang file.\r\n" + key + " = " + defaultValue);
        }
        return key == null || this.bundle == null || !this.bundle.containsKey(key) ? defaultValue : this.bundle.getString(key);
    }
}

