/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util;

import java.io.StringWriter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtilities {
    private XMLUtilities() {
    }

    public static String transformDocument2String(Document doc) {
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException("Fehler beim Konvertieren in einen String ", ex);
        }
    }

    public static Object xpathSearch(Node node, String xpathPattern, NamespaceContext namespaceContext, QName type) {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        if (namespaceContext != null) {
            xpath.setNamespaceContext(namespaceContext);
        }
        if (type == null) {
            type = XPathConstants.NODESET;
        }
        try {
            XPathExpression expression = xpath.compile(xpathPattern);
            return expression.evaluate(node, type);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object xpathSearch(Document doc, String xpathPattern, NamespaceContext namespaceContext, QName type) {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        if (namespaceContext != null) {
            xpath.setNamespaceContext(namespaceContext);
        }
        if (type == null) {
            type = XPathConstants.NODESET;
        }
        try {
            XPathExpression expression = xpath.compile(xpathPattern);
            return expression.evaluate(doc, type);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document copySubTree(Document srcDocument, String tagname) {
        return XMLUtilities.copySubTree(srcDocument, tagname, 0);
    }

    public static Document copySubTree(Document srcDocument, String tagname, int index) {
        NodeList nodes = srcDocument.getElementsByTagName(tagname);
        if (nodes.getLength() > index) {
            return XMLUtilities.copySubTree(nodes.item(index));
        }
        return null;
    }

    public static Document copySubTree(Node node) {
        try {
            Document trgDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Node newNode = trgDocument.importNode(node, true);
            trgDocument.appendChild(newNode);
            return trgDocument;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

