/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javafx.collections.ModifiableObservableListBase;
import javafx.collections.ObservableList;

public class ObservableUniqueList<T>
extends ModifiableObservableListBase<T>
implements ObservableList<T> {
    private final List<T> list;
    private final Set<T> set;

    public ObservableUniqueList() {
        this.list = new ArrayList<T>();
        this.set = new HashSet<T>();
    }

    public ObservableUniqueList(int size) {
        this.list = new ArrayList<T>(size);
        this.set = new HashSet<T>(size);
    }

    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    public void clear() {
        this.set.clear();
        this.list.clear();
    }

    public boolean contains(Object object) {
        return this.set.contains(object);
    }

    public ListIterator<T> listIterator(int index) {
        return new ListIterator<T>(index){
            private final ListIterator<T> backingIt;
            private T lastReturned;
            {
                this.backingIt = ObservableUniqueList.this.list.listIterator(n);
            }

            @Override
            public boolean hasNext() {
                return this.backingIt.hasNext();
            }

            @Override
            public T next() {
                this.lastReturned = this.backingIt.next();
                return this.lastReturned;
            }

            @Override
            public boolean hasPrevious() {
                return this.backingIt.hasPrevious();
            }

            @Override
            public T previous() {
                this.lastReturned = this.backingIt.previous();
                return this.lastReturned;
            }

            @Override
            public int nextIndex() {
                return this.backingIt.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.backingIt.previousIndex();
            }

            @Override
            public void remove() {
                try {
                    ObservableUniqueList.this.beginChange();
                    int idx = this.previousIndex();
                    this.backingIt.remove();
                    ObservableUniqueList.this.nextRemove(idx, this.lastReturned);
                    ObservableUniqueList.this.set.remove(this.lastReturned);
                }
                finally {
                    ObservableUniqueList.this.endChange();
                }
            }

            @Override
            public void set(T e) {
                if (e == null) {
                    throw new NullPointerException("Error, list does not support null values!");
                }
                if (ObservableUniqueList.this.set.contains(e)) {
                    throw new IllegalArgumentException("Error, list elements must be unique but element already exists " + String.valueOf(e) + "!");
                }
                try {
                    ObservableUniqueList.this.beginChange();
                    int idx = this.previousIndex();
                    this.backingIt.set(e);
                    ObservableUniqueList.this.set.add(e);
                    ObservableUniqueList.this.nextSet(idx, this.lastReturned);
                }
                finally {
                    ObservableUniqueList.this.endChange();
                }
            }

            @Override
            public void add(T e) {
                if (e == null) {
                    throw new NullPointerException("Error, list does not support null values!");
                }
                if (ObservableUniqueList.this.set.contains(e)) {
                    throw new IllegalArgumentException("Error, list elements must be unique but element already exists " + String.valueOf(e) + "!");
                }
                try {
                    ObservableUniqueList.this.beginChange();
                    int idx = this.nextIndex();
                    this.backingIt.add(e);
                    ObservableUniqueList.this.set.add(e);
                    ObservableUniqueList.this.nextAdd(idx, idx + 1);
                }
                finally {
                    ObservableUniqueList.this.endChange();
                }
            }
        };
    }

    public Iterator<T> iterator() {
        return this.listIterator();
    }

    public T get(int index) {
        try {
            return this.list.listIterator(index).next();
        }
        catch (NoSuchElementException exc) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }

    public boolean addAll(Collection<? extends T> c) {
        return this.addAll(0, c);
    }

    public boolean addAll(int index, Collection<? extends T> c) {
        this.beginChange();
        try {
            boolean modified = false;
            ListIterator<T> e1 = this.listIterator(index);
            Iterator<T> e2 = c.iterator();
            while (e2.hasNext()) {
                e1.add(e2.next());
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        catch (NoSuchElementException exc) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        finally {
            this.endChange();
        }
    }

    public boolean removeAll(Collection<?> c) {
        this.beginChange();
        try {
            Objects.requireNonNull(c);
            boolean modified = false;
            if (this.size() > c.size()) {
                Iterator<?> e = c.iterator();
                while (e.hasNext()) {
                    modified |= this.remove(e.next());
                }
            } else {
                Collection<?> removals = null;
                removals = c instanceof ObservableUniqueList ? c : new HashSet(c);
                Iterator<T> e = this.iterator();
                while (e.hasNext()) {
                    if (!removals.contains(e.next())) continue;
                    e.remove();
                    modified = true;
                }
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.endChange();
        }
    }

    public int size() {
        return this.list.size();
    }

    protected void doAdd(int index, T element) {
        if (element == null) {
            throw new NullPointerException("Error, list does not support null values!");
        }
        if (this.set.contains(element)) {
            throw new IllegalArgumentException("Error, list elements must be unique but element already exists " + String.valueOf(element) + "!");
        }
        try {
            this.list.listIterator(index).add(element);
            this.set.add(element);
        }
        catch (NoSuchElementException exc) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }

    protected T doSet(int index, T element) {
        if (element == null) {
            throw new NullPointerException("Error, list does not support null values!");
        }
        if (this.set.contains(element)) {
            throw new IllegalArgumentException("Error, list elements must be unique but element already exists " + String.valueOf(element) + "!");
        }
        try {
            ListIterator<T> e = this.list.listIterator(index);
            T oldVal = e.next();
            this.set.remove(oldVal);
            this.set.add(element);
            e.set(element);
            return oldVal;
        }
        catch (NoSuchElementException exc) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }

    protected T doRemove(int index) {
        try {
            ListIterator<T> e = this.list.listIterator(index);
            T element = e.next();
            this.set.remove(element);
            e.remove();
            return element;
        }
        catch (NoSuchElementException exc) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }
}

