/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util;

import java.util.LinkedList;
import javafx.collections.ModifiableObservableListBase;

public class ObservableLimitedList<T>
extends ModifiableObservableListBase<T> {
    private LinkedList<T> list;
    private int maxSize;

    public ObservableLimitedList(int maxSize) {
        this.maxSize = maxSize;
        this.list = new LinkedList();
    }

    public boolean add(T element) {
        boolean result = super.add(element);
        if (this.size() > this.maxSize) {
            this.remove(0);
        }
        return result;
    }

    public T get(int index) {
        return this.list.get(index);
    }

    public int size() {
        return this.list.size();
    }

    protected void doAdd(int index, T element) {
        this.list.add(index, element);
    }

    protected T doSet(int index, T element) {
        return this.list.set(index, element);
    }

    protected T doRemove(int index) {
        return this.list.remove(index);
    }
}

