/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.util;

import java.io.BufferedInputStream;
import java.util.Properties;
import org.applied_geodesy.util.unit.AngleUnit;
import org.applied_geodesy.util.unit.LengthUnit;
import org.applied_geodesy.util.unit.PercentUnit;
import org.applied_geodesy.util.unit.PressureUnit;
import org.applied_geodesy.util.unit.ScaleUnit;
import org.applied_geodesy.util.unit.TemperatureUnit;
import org.applied_geodesy.util.unit.UnitType;

public class DefaultFormatterOption {
    private static final LengthUnit LENGTH_UNIT = LengthUnit.METER;
    private static final AngleUnit ANGLE_UNIT = AngleUnit.GRADIAN;
    private static final ScaleUnit SCALE_UNIT = ScaleUnit.PARTS_PER_MILLION_WRT_ONE;
    private static final LengthUnit VECTOR_UNIT = LengthUnit.METER;
    private static final LengthUnit LENGTH_UNCERTAINTY_UNIT = LengthUnit.MILLIMETER;
    private static final AngleUnit ANGLE_UNCERTAINTY_UNIT = AngleUnit.MILLIGRADIAN;
    private static final ScaleUnit SCALE_UNCERTAINTY_UNIT = ScaleUnit.PARTS_PER_MILLION_WRT_ZERO;
    private static final LengthUnit VECTOR_UNCERTAINTY_UNIT = LengthUnit.MILLIMETER;
    private static final LengthUnit LENGTH_RESIDUAL_UNIT = LengthUnit.MILLIMETER;
    private static final AngleUnit ANGLE_RESIDUAL_UNIT = AngleUnit.MILLIGRADIAN;
    private static final ScaleUnit SCALE_RESIDUAL_UNIT = ScaleUnit.PARTS_PER_MILLION_WRT_ZERO;
    private static final LengthUnit VECTOR_RESIDUAL_UNIT = LengthUnit.MILLIMETER;
    private static final TemperatureUnit TEMPERATURE_UNIT = TemperatureUnit.DEGREE_CELSIUS;
    private static final PressureUnit PRESSURE_UNIT = PressureUnit.HECTOPASCAL;
    private static final PercentUnit PERCENT_UNIT = PercentUnit.PERCENT;
    private static final int LENGTH_FRACTION_DIGITS = 4;
    private static final int ANGLE_FRACTION_DIGITS = 5;
    private static final int SCALE_FRACTION_DIGITS = 2;
    private static final int VECTOR_FRACTION_DIGITS = 7;
    private static final int LENGTH_UNCERTAINTY_FRACTION_DIGITS = 1;
    private static final int ANGLE_UNCERTAINTY_FRACTION_DIGITS = 2;
    private static final int SCALE_UNCERTAINTY_FRACTION_DIGITS = 1;
    private static final int VECTOR_UNCERTAINTY_FRACTION_DIGITS = 1;
    private static final int LENGTH_RESIDUAL_FRACTION_DIGITS = 1;
    private static final int ANGLE_RESIDUAL_FRACTION_DIGITS = 2;
    private static final int SCALE_RESIDUAL_FRACTION_DIGITS = 2;
    private static final int VECTOR_RESIDUAL_FRACTION_DIGITS = 2;
    private static final int TEMPERATURE_FRACTION_DIGITS = 1;
    private static final int PRESSURE_FRACTION_DIGITS = 2;
    private static final int PERCENT_FRACTION_DIGITS = 2;
    private static final int STATISTIC_FRACTION_DIGITS = 2;
    private static final int DOUBLE_FRACTION_DIGITS = 5;
    private static final Properties PROPERTIES = new Properties();

    static {
        BufferedInputStream bis = null;
        String path = "properties/formatteroptions.default";
        try {
            try {
                if (DefaultFormatterOption.class.getClassLoader().getResourceAsStream("properties/formatteroptions.default") != null) {
                    bis = new BufferedInputStream(DefaultFormatterOption.class.getClassLoader().getResourceAsStream("properties/formatteroptions.default"));
                    PROPERTIES.load(bis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private DefaultFormatterOption() {
    }

    public static int getLengthFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("LENGTH_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 4;
    }

    public static int getAngleFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("ANGLE_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 5;
    }

    public static int getScaleFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("SCALE_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 2;
    }

    public static int getVectorFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("VECTOR_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 7;
    }

    public static int getLengthUncertaintyFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("LENGTH_UNCERTAINTY_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 1;
    }

    public static int getAngleUncertaintyFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("ANGLE_UNCERTAINTY_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 2;
    }

    public static int getScaleUncertaintyFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("SCALE_UNCERTAINTY_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 1;
    }

    public static int getVectorUncertaintyFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("VECTOR_UNCERTAINTY_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 1;
    }

    public static int getLengthResidualFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("LENGTH_RESIDUAL_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 1;
    }

    public static int getAngleResidualFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("ANGLE_RESIDUAL_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 2;
    }

    public static int getScaleResidualFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("SCALE_RESIDUAL_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 2;
    }

    public static int getVectorResidualFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("VECTOR_RESIDUAL_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 2;
    }

    public static int getTemperatureFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("TEMPERATURE_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 1;
    }

    public static int getPressureFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("PRESSURE_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 2;
    }

    public static int getPercentFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("PERCENT_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 2;
    }

    public static int getStatisticFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("STATISTIC_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 2;
    }

    public static int getDoubleFractionDigits() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("DOUBLE_FRACTION_DIGITS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0 ? value : 5;
    }

    public static LengthUnit getLengthUnit() {
        try {
            UnitType unitType = UnitType.valueOf(PROPERTIES.getProperty("LENGTH_UNIT"));
            if (unitType != null && LengthUnit.UNITS.containsKey((Object)unitType)) {
                return LengthUnit.getUnit(unitType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return LENGTH_UNIT;
    }

    public static AngleUnit getAngleUnit() {
        try {
            UnitType unitType = UnitType.valueOf(PROPERTIES.getProperty("ANGLE_UNIT"));
            if (unitType != null && AngleUnit.UNITS.containsKey((Object)unitType)) {
                return AngleUnit.getUnit(unitType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ANGLE_UNIT;
    }

    public static ScaleUnit getScaleUnit() {
        try {
            UnitType unitType = UnitType.valueOf(PROPERTIES.getProperty("SCALE_UNIT"));
            if (unitType != null && ScaleUnit.UNITS.containsKey((Object)unitType)) {
                return ScaleUnit.getUnit(unitType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return SCALE_UNIT;
    }

    public static LengthUnit getVectorUnit() {
        try {
            UnitType unitType = UnitType.valueOf(PROPERTIES.getProperty("VECTOR_UNIT"));
            if (unitType != null && LengthUnit.UNITS.containsKey((Object)unitType)) {
                return LengthUnit.getUnit(unitType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return VECTOR_UNIT;
    }

    public static LengthUnit getLengthUncertaintyUnit() {
        try {
            UnitType unitType = UnitType.valueOf(PROPERTIES.getProperty("LENGTH_UNCERTAINTY_UNIT"));
            if (unitType != null && LengthUnit.UNITS.containsKey((Object)unitType)) {
                return LengthUnit.getUnit(unitType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return LENGTH_UNCERTAINTY_UNIT;
    }

    public static AngleUnit getAngleUncertaintyUnit() {
        try {
            UnitType unitType = UnitType.valueOf(PROPERTIES.getProperty("ANGLE_UNCERTAINTY_UNIT"));
            if (unitType != null && AngleUnit.UNITS.containsKey((Object)unitType)) {
                return AngleUnit.getUnit(unitType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ANGLE_UNCERTAINTY_UNIT;
    }

    public static ScaleUnit getScaleUncertaintyUnit() {
        try {
            UnitType unitType = UnitType.valueOf(PROPERTIES.getProperty("SCALE_UNCERTAINTY_UNIT"));
            if (unitType != null && ScaleUnit.UNITS.containsKey((Object)unitType)) {
                return ScaleUnit.getUnit(unitType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return SCALE_UNCERTAINTY_UNIT;
    }

    public static LengthUnit getVectorUncertaintyUnit() {
        try {
            UnitType unitType = UnitType.valueOf(PROPERTIES.getProperty("VECTOR_UNCERTAINTY_UNIT"));
            if (unitType != null && LengthUnit.UNITS.containsKey((Object)unitType)) {
                return LengthUnit.getUnit(unitType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return VECTOR_UNCERTAINTY_UNIT;
    }

    public static LengthUnit getLengthResidualUnit() {
        try {
            UnitType unitType = UnitType.valueOf(PROPERTIES.getProperty("LENGTH_RESIDUAL_UNIT"));
            if (unitType != null && LengthUnit.UNITS.containsKey((Object)unitType)) {
                return LengthUnit.getUnit(unitType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return LENGTH_RESIDUAL_UNIT;
    }

    public static AngleUnit getAngleResidualUnit() {
        try {
            UnitType unitType = UnitType.valueOf(PROPERTIES.getProperty("ANGLE_RESIDUAL_UNIT"));
            if (unitType != null && AngleUnit.UNITS.containsKey((Object)unitType)) {
                return AngleUnit.getUnit(unitType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ANGLE_RESIDUAL_UNIT;
    }

    public static ScaleUnit getScaleResidualUnit() {
        try {
            UnitType unitType = UnitType.valueOf(PROPERTIES.getProperty("SCALE_RESIDUAL_UNIT"));
            if (unitType != null && ScaleUnit.UNITS.containsKey((Object)unitType)) {
                return ScaleUnit.getUnit(unitType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return SCALE_RESIDUAL_UNIT;
    }

    public static LengthUnit getVectorResidualUnit() {
        try {
            UnitType unitType = UnitType.valueOf(PROPERTIES.getProperty("VECTOR_RESIDUAL_UNIT"));
            if (unitType != null && LengthUnit.UNITS.containsKey((Object)unitType)) {
                return LengthUnit.getUnit(unitType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return VECTOR_RESIDUAL_UNIT;
    }

    public static TemperatureUnit getTemperatureUnit() {
        try {
            UnitType unitType = UnitType.valueOf(PROPERTIES.getProperty("TEMPERATURE_UNIT"));
            if (unitType != null && TemperatureUnit.UNITS.containsKey((Object)unitType)) {
                return TemperatureUnit.getUnit(unitType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TEMPERATURE_UNIT;
    }

    public static PressureUnit getPressureUnit() {
        try {
            UnitType unitType = UnitType.valueOf(PROPERTIES.getProperty("PRESSURE_UNIT"));
            if (unitType != null && PressureUnit.UNITS.containsKey((Object)unitType)) {
                return PressureUnit.getUnit(unitType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PRESSURE_UNIT;
    }

    public static PercentUnit getPercentUnit() {
        try {
            UnitType unitType = UnitType.valueOf(PROPERTIES.getProperty("PERCENT_UNIT"));
            if (unitType != null && PercentUnit.UNITS.containsKey((Object)unitType)) {
                return PercentUnit.getUnit(unitType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PERCENT_UNIT;
    }
}

