/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.ui.textfield;

import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.util.CellValueType;

public class MinMaxDoubleTextField
extends DoubleTextField {
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;
    private boolean exclusiveMin = true;
    private boolean exclusiveMax = true;

    public MinMaxDoubleTextField(Double value, double min, double max, CellValueType type, boolean displayUnit, boolean exclusiveMin, boolean exclusiveMax) {
        super(value, type, displayUnit, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT);
        this.exclusiveMin = exclusiveMin;
        this.exclusiveMax = exclusiveMax;
        this.min = Math.min(min, max);
        this.max = Math.max(min, max);
        this.setNumber(value);
        this.setText(this.getRendererFormat(value));
    }

    @Override
    public boolean check(Double value) {
        boolean validNumber = super.check(value);
        if (!validNumber) {
            return false;
        }
        if (value == null) {
            return true;
        }
        return (this.exclusiveMin ? this.min < value : this.min <= value) && (this.exclusiveMax ? value < this.max : value <= this.max);
    }
}

