/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.ui.textfield;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterOptions;

public class DoubleTextField
extends TextField
implements FormatterChangedListener {
    private FormatterOptions options = FormatterOptions.getInstance();
    private static final int EDITOR_ADDITIONAL_DIGITS = 10;
    private double lowerBoundary = Double.NEGATIVE_INFINITY;
    private double upperBoundary = Double.POSITIVE_INFINITY;
    private NumberFormat editorNumberFormat;
    private CellValueType type;
    private final boolean displayUnit;
    private final ValueSupport valueSupport;
    private ObjectProperty<Double> number = new SimpleObjectProperty();
    private boolean typeChanged = false;

    public DoubleTextField(CellValueType type) {
        this(null, type, false);
    }

    public DoubleTextField(CellValueType type, boolean displayUnit) {
        this(null, type, displayUnit);
    }

    public DoubleTextField(Double value, CellValueType type, boolean displayUnit) {
        this(value, type, displayUnit, ValueSupport.NULL_VALUE_SUPPORT);
    }

    public DoubleTextField(Double value, CellValueType type, boolean displayUnit, ValueSupport valueSupport) {
        this(value, type, displayUnit, valueSupport, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleTextField(Double value, CellValueType type, boolean displayUnit, ValueSupport valueSupport, double lowerBoundary, double upperBoundary) {
        this.type = type;
        this.valueSupport = valueSupport;
        this.displayUnit = displayUnit;
        this.lowerBoundary = lowerBoundary;
        this.upperBoundary = upperBoundary;
        if (this.check(value)) {
            this.setNumber(value);
        }
        this.prepareEditorNumberFormat();
        this.initHandlers();
        this.setTextFormatter(this.createTextFormatter());
        if (this.check(value)) {
            this.setText(this.getRendererFormat(value));
        }
        this.options.addFormatterChangedListener(this);
    }

    public void setCellValueType(CellValueType type) {
        this.type = type;
        this.typeChanged = true;
        double value = this.getNumber();
        if (this.check(value)) {
            this.setNumber(value);
        }
        this.prepareEditorNumberFormat();
        this.setTextFormatter(this.createTextFormatter());
        if (this.check(value)) {
            this.setText(this.getRendererFormat(value));
        }
    }

    private void prepareEditorNumberFormat() {
        this.editorNumberFormat = (NumberFormat)this.options.getFormatterOptions().get((Object)this.type).getFormatter().clone();
        this.editorNumberFormat.setMinimumFractionDigits(this.editorNumberFormat.getMaximumFractionDigits());
        this.editorNumberFormat.setMaximumFractionDigits(this.editorNumberFormat.getMaximumFractionDigits() + 10);
    }

    public boolean check(Double value) {
        switch (this.valueSupport) {
            case INCLUDING_INCLUDING_INTERVAL: {
                return value != null && this.lowerBoundary <= value && value <= this.upperBoundary;
            }
            case EXCLUDING_EXCLUDING_INTERVAL: {
                return value != null && this.lowerBoundary < value && value < this.upperBoundary;
            }
            case INCLUDING_EXCLUDING_INTERVAL: {
                return value != null && this.lowerBoundary <= value && value < this.upperBoundary;
            }
            case EXCLUDING_INCLUDING_INTERVAL: {
                return value != null && this.lowerBoundary < value && value <= this.upperBoundary;
            }
            case NON_NULL_VALUE_SUPPORT: {
                return value != null;
            }
        }
        return true;
    }

    private TextFormatter<Double> createTextFormatter() {
        final Pattern decimalPattern = Pattern.compile("^[+|-]?[\\d\\D]*?\\d{0," + this.editorNumberFormat.getMaximumFractionDigits() + "}\\s*\\D*$");
        UnaryOperator<TextFormatter.Change> filter = new UnaryOperator<TextFormatter.Change>(){

            @Override
            public TextFormatter.Change apply(TextFormatter.Change change) {
                if (!change.isContentChange()) {
                    return change;
                }
                try {
                    String input = change.getControlNewText();
                    if (input == null || input.trim().isEmpty() || decimalPattern.matcher(input.trim()).matches()) {
                        return change;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        return new TextFormatter((UnaryOperator)filter);
    }

    private void initHandlers() {
        this.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DoubleTextField.this.parseAndFormatInput();
            }
        });
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (DoubleTextField.this.typeChanged) {
                    DoubleTextField.this.typeChanged = false;
                    DoubleTextField.this.setText(DoubleTextField.this.getEditorFormat(DoubleTextField.this.getNumber()));
                }
                if (!newValue.booleanValue()) {
                    DoubleTextField.this.parseAndFormatInput();
                    DoubleTextField.this.setText(DoubleTextField.this.getRendererFormat(DoubleTextField.this.getNumber()));
                } else {
                    DoubleTextField.this.setText(DoubleTextField.this.getEditorFormat(DoubleTextField.this.getNumber()));
                }
            }
        });
        this.numberProperty().addListener((ChangeListener)new ChangeListener<Double>(){

            public void changed(ObservableValue<? extends Double> obserable, Double oldValue, Double newValue) {
                if (!DoubleTextField.this.isDisable()) {
                    DoubleTextField.this.setText(DoubleTextField.this.getEditorFormat(DoubleTextField.this.getNumber()));
                } else {
                    DoubleTextField.this.setText(DoubleTextField.this.getRendererFormat(newValue));
                }
            }
        });
    }

    private String getEditorFormat(Double value) {
        if (!this.check(value)) {
            return null;
        }
        value = this.getNumber();
        if (value == null) {
            return null;
        }
        switch (this.type) {
            case ANGLE: {
                return this.editorNumberFormat.format(this.options.convertAngleToView(value));
            }
            case ANGLE_RESIDUAL: {
                return this.editorNumberFormat.format(this.options.convertAngleResidualToView(value));
            }
            case ANGLE_UNCERTAINTY: {
                return this.editorNumberFormat.format(this.options.convertAngleUncertaintyToView(value));
            }
            case LENGTH: {
                return this.editorNumberFormat.format(this.options.convertLengthToView(value));
            }
            case LENGTH_RESIDUAL: {
                return this.editorNumberFormat.format(this.options.convertLengthResidualToView(value));
            }
            case LENGTH_UNCERTAINTY: {
                return this.editorNumberFormat.format(this.options.convertLengthUncertaintyToView(value));
            }
            case SCALE: {
                return this.editorNumberFormat.format(this.options.convertScaleToView(value));
            }
            case SCALE_RESIDUAL: {
                return this.editorNumberFormat.format(this.options.convertScaleResidualToView(value));
            }
            case SCALE_UNCERTAINTY: {
                return this.editorNumberFormat.format(this.options.convertScaleUncertaintyToView(value));
            }
            case DOUBLE: 
            case STATISTIC: {
                return this.editorNumberFormat.format(value);
            }
            case VECTOR: {
                return this.editorNumberFormat.format(this.options.convertVectorToView(value));
            }
            case VECTOR_RESIDUAL: {
                return this.editorNumberFormat.format(this.options.convertVectorResidualToView(value));
            }
            case VECTOR_UNCERTAINTY: {
                return this.editorNumberFormat.format(this.options.convertVectorUncertaintyToView(value));
            }
            case TEMPERATURE: {
                return this.editorNumberFormat.format(this.options.convertTemperatureToView(value));
            }
            case PRESSURE: {
                return this.editorNumberFormat.format(this.options.convertPressureToView(value));
            }
            case PERCENTAGE: {
                return this.editorNumberFormat.format(this.options.convertPercentToView(value));
            }
        }
        return this.editorNumberFormat.format(value);
    }

    String getRendererFormat(Double value) {
        if (!this.check(value)) {
            return null;
        }
        value = this.getNumber();
        if (value == null) {
            return null;
        }
        switch (this.type) {
            case ANGLE: {
                return this.options.toAngleFormat(value, this.displayUnit);
            }
            case ANGLE_RESIDUAL: {
                return this.options.toAngleResidualFormat(value, this.displayUnit);
            }
            case ANGLE_UNCERTAINTY: {
                return this.options.toAngleUncertaintyFormat(value, this.displayUnit);
            }
            case LENGTH: {
                return this.options.toLengthFormat(value, this.displayUnit);
            }
            case LENGTH_RESIDUAL: {
                return this.options.toLengthResidualFormat(value, this.displayUnit);
            }
            case LENGTH_UNCERTAINTY: {
                return this.options.toLengthUncertaintyFormat(value, this.displayUnit);
            }
            case SCALE: {
                return this.options.toScaleFormat(value, this.displayUnit);
            }
            case SCALE_RESIDUAL: {
                return this.options.toScaleResidualFormat(value, this.displayUnit);
            }
            case SCALE_UNCERTAINTY: {
                return this.options.toScaleUncertaintyFormat(value, this.displayUnit);
            }
            case STATISTIC: {
                return this.options.toStatisticFormat(value);
            }
            case VECTOR: {
                return this.options.toVectorFormat(value, this.displayUnit);
            }
            case VECTOR_RESIDUAL: {
                return this.options.toVectorResidualFormat(value, this.displayUnit);
            }
            case VECTOR_UNCERTAINTY: {
                return this.options.toVectorUncertaintyFormat(value, this.displayUnit);
            }
            case TEMPERATURE: {
                return this.options.toTemperatureFormat(value, this.displayUnit);
            }
            case PRESSURE: {
                return this.options.toPressureFormat(value, this.displayUnit);
            }
            case PERCENTAGE: {
                return this.options.toPercentFormat(value, this.displayUnit);
            }
            case DOUBLE: {
                return this.options.toDoubleFormat(value);
            }
        }
        return null;
    }

    private void parseAndFormatInput() {
        try {
            String input = this.getText();
            if (input != null && !input.isBlank()) {
                input = input.trim();
                if ((input = input.replaceAll(",", ".")).startsWith("+")) {
                    input = input.substring(1);
                }
                ParsePosition parsePosition = new ParsePosition(0);
                Double newValue = this.options.getFormatterOptions().get((Object)this.type).parse(input, parsePosition).doubleValue();
                if (newValue != null && parsePosition.getErrorIndex() < 0 && parsePosition.getIndex() == input.length()) {
                    switch (this.type) {
                        case ANGLE: {
                            newValue = this.options.convertAngleToModel(newValue);
                            break;
                        }
                        case ANGLE_RESIDUAL: {
                            newValue = this.options.convertAngleResidualToModel(newValue);
                            break;
                        }
                        case ANGLE_UNCERTAINTY: {
                            newValue = this.options.convertAngleUncertaintyToModel(newValue);
                            break;
                        }
                        case LENGTH: {
                            newValue = this.options.convertLengthToModel(newValue);
                            break;
                        }
                        case LENGTH_RESIDUAL: {
                            newValue = this.options.convertLengthResidualToModel(newValue);
                            break;
                        }
                        case LENGTH_UNCERTAINTY: {
                            newValue = this.options.convertLengthUncertaintyToModel(newValue);
                            break;
                        }
                        case SCALE: {
                            newValue = this.options.convertScaleToModel(newValue);
                            break;
                        }
                        case SCALE_RESIDUAL: {
                            newValue = this.options.convertScaleResidualToModel(newValue);
                            break;
                        }
                        case SCALE_UNCERTAINTY: {
                            newValue = this.options.convertScaleUncertaintyToModel(newValue);
                            break;
                        }
                        case DOUBLE: 
                        case STATISTIC: {
                            newValue = (double)newValue;
                            break;
                        }
                        case VECTOR: {
                            newValue = this.options.convertVectorToModel(newValue);
                            break;
                        }
                        case VECTOR_RESIDUAL: {
                            newValue = this.options.convertVectorResidualToModel(newValue);
                            break;
                        }
                        case VECTOR_UNCERTAINTY: {
                            newValue = this.options.convertVectorUncertaintyToModel(newValue);
                            break;
                        }
                        case TEMPERATURE: {
                            newValue = this.options.convertTemperatureToModel(newValue);
                            break;
                        }
                        case PRESSURE: {
                            newValue = this.options.convertPressureToModel(newValue);
                            break;
                        }
                        case PERCENTAGE: {
                            newValue = this.options.convertPercentToModel(newValue);
                            break;
                        }
                        default: {
                            newValue = (double)newValue;
                        }
                    }
                    this.setNumber(!this.check(newValue) ? this.getNumber() : newValue);
                } else {
                    this.setText(this.getRendererFormat(this.getNumber()));
                }
            } else if ((input == null || input.isBlank()) && this.check(null)) {
                this.setNumber(null);
            }
            this.selectAll();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setText(this.getRendererFormat(this.getNumber()));
        }
    }

    public final Double getNumber() {
        return (Double)this.number.get();
    }

    public final void setNumber(Double value) {
        this.number.set((Object)value);
    }

    public final void setValue(Double value) {
        this.number.set((Object)value);
        this.setText(this.getRendererFormat(value));
    }

    public ObjectProperty<Double> numberProperty() {
        return this.number;
    }

    public CellValueType getCellValueType() {
        return this.type;
    }

    public boolean isDisplayUnit() {
        return this.displayUnit;
    }

    public ValueSupport getValueSupport() {
        return this.valueSupport;
    }

    @Override
    public void formatterChanged(FormatterEvent evt) {
        this.prepareEditorNumberFormat();
        this.setText(this.getRendererFormat(this.getNumber()));
    }

    public static enum ValueSupport {
        INCLUDING_INCLUDING_INTERVAL,
        INCLUDING_EXCLUDING_INTERVAL,
        EXCLUDING_INCLUDING_INTERVAL,
        EXCLUDING_EXCLUDING_INTERVAL,
        NULL_VALUE_SUPPORT,
        NON_NULL_VALUE_SUPPORT;

    }
}

