/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.ui.tex;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import org.scilab.forge.jlatexmath.TeXFormula;

public class LaTexLabel
extends Label {
    private int style = 0;
    private float size = 16.0f;
    private Color foregroundColor = Color.BLACK;
    private StringProperty tex = new SimpleStringProperty();

    public LaTexLabel() {
        this(null);
    }

    public LaTexLabel(String tex) {
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.tex.addListener((ChangeListener)new TexChangeListener());
        this.setTex(tex);
    }

    private void process() {
        if (((String)this.tex.get()).isBlank()) {
            this.setGraphic(null);
        } else {
            TeXFormula formula = new TeXFormula((String)this.tex.get());
            Image imageAWT = formula.createBufferedImage(this.style, this.size, this.foregroundColor, null);
            WritableImage writableImage = SwingFXUtils.toFXImage((BufferedImage)((BufferedImage)imageAWT), null);
            ImageView view = new ImageView((javafx.scene.image.Image)writableImage);
            this.setGraphic((Node)view);
        }
    }

    public StringProperty texProperty() {
        return this.tex;
    }

    public String getTex() {
        return (String)this.tex.get();
    }

    public void setTex(String tex) {
        this.tex.set((Object)tex);
    }

    public void setStyle(int style) {
        this.style = style;
        this.process();
    }

    public void setSize(float size) {
        this.size = size;
        this.process();
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
        this.process();
    }

    private class TexChangeListener
    implements ChangeListener<String> {
        private TexChangeListener() {
        }

        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            LaTexLabel.this.process();
        }
    }
}

