/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.ui.table;

import java.util.Comparator;

public class NaturalOrderComparator<T>
implements Comparator<T> {
    @Override
    public int compare(T o1, T o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        String a = o1.toString();
        String b = o2.toString();
        int ia = 0;
        int ib = 0;
        int nza = 0;
        int nzb = 0;
        while (true) {
            int bias;
            nzb = 0;
            nza = 0;
            char ca = this.charAt(a, ia);
            char cb = this.charAt(b, ib);
            while (Character.isSpaceChar(ca) || ca == '0') {
                nza = ca == '0' ? ++nza : 0;
                ca = this.charAt(a, ++ia);
            }
            while (Character.isSpaceChar(cb) || cb == '0') {
                nzb = cb == '0' ? ++nzb : 0;
                cb = this.charAt(b, ++ib);
            }
            if (Character.isDigit(ca) && Character.isDigit(cb) && (bias = this.compareRight(a.substring(ia), b.substring(ib))) != 0) {
                return bias;
            }
            if (ca == '\u0000' && cb == '\u0000') {
                return this.compareEqual(a, b, nza, nzb);
            }
            if (ca < cb) {
                return -1;
            }
            if (ca > cb) {
                return 1;
            }
            ++ia;
            ++ib;
        }
    }

    private int compareRight(String a, String b) {
        int bias = 0;
        int ia = 0;
        int ib = 0;
        while (true) {
            char ca = this.charAt(a, ia);
            char cb = this.charAt(b, ib);
            if (!this.isDigit(ca) && !this.isDigit(cb)) {
                return bias;
            }
            if (!this.isDigit(ca)) {
                return -1;
            }
            if (!this.isDigit(cb)) {
                return 1;
            }
            if (ca == '\u0000' && cb == '\u0000') {
                return bias;
            }
            if (bias == 0) {
                if (ca < cb) {
                    bias = -1;
                } else if (ca > cb) {
                    bias = 1;
                }
            }
            ++ia;
            ++ib;
        }
    }

    private boolean isDigit(char c) {
        return Character.isDigit(c) || c == '.' || c == ',';
    }

    private char charAt(String s, int i) {
        return i >= s.length() ? (char)'\u0000' : s.charAt(i);
    }

    private int compareEqual(String a, String b, int nza, int nzb) {
        if (nza - nzb != 0) {
            return nza - nzb;
        }
        if (a.length() == b.length()) {
            return a.compareTo(b);
        }
        return a.length() - b.length();
    }
}

