/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.ui.table;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.applied_geodesy.ui.table.EditableCellConverter;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterOptions;

public class EditableDoubleCellConverter
extends EditableCellConverter<Double> {
    private CellValueType cellValueType;
    private final FormatterOptions options = FormatterOptions.getInstance();
    private final NumberFormat editorNumberFormat = NumberFormat.getInstance(Locale.ENGLISH);
    private boolean displayUnit = false;
    private static final int EXTRA_DIGITS_ON_EDIT = 7;

    public EditableDoubleCellConverter(CellValueType cellValueType) {
        this(cellValueType, false);
    }

    public EditableDoubleCellConverter(CellValueType cellValueType, boolean displayUnit) {
        this.cellValueType = cellValueType;
        this.displayUnit = displayUnit;
        int fracDigits = this.options.getFormatterOptions().get((Object)this.cellValueType).getFractionDigits();
        this.editorNumberFormat.setGroupingUsed(false);
        this.editorNumberFormat.setMaximumFractionDigits(fracDigits + 7);
        this.editorNumberFormat.setMinimumFractionDigits(fracDigits);
    }

    public void setCellValueType(CellValueType cellValueType) {
        this.cellValueType = cellValueType;
        int fracDigits = this.options.getFormatterOptions().get((Object)this.cellValueType).getFractionDigits();
        this.editorNumberFormat.setGroupingUsed(false);
        this.editorNumberFormat.setMaximumFractionDigits(fracDigits + 7);
        this.editorNumberFormat.setMinimumFractionDigits(fracDigits);
    }

    @Override
    public String toEditorString(Double value) {
        block22: {
            try {
                if (value != null) break block22;
                return "";
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
                return "";
            }
        }
        int fracDigits = this.options.getFormatterOptions().get((Object)this.cellValueType).getFractionDigits();
        if (this.editorNumberFormat.getMinimumFractionDigits() != fracDigits) {
            this.editorNumberFormat.setMaximumFractionDigits(fracDigits + 7);
            this.editorNumberFormat.setMinimumFractionDigits(fracDigits);
        }
        switch (this.cellValueType) {
            case ANGLE: {
                return this.editorNumberFormat.format(this.options.convertAngleToView(value));
            }
            case ANGLE_RESIDUAL: {
                return this.editorNumberFormat.format(this.options.convertAngleResidualToView(value));
            }
            case ANGLE_UNCERTAINTY: {
                return this.editorNumberFormat.format(this.options.convertAngleUncertaintyToView(value));
            }
            case LENGTH: {
                return this.editorNumberFormat.format(this.options.convertLengthToView(value));
            }
            case LENGTH_RESIDUAL: {
                return this.editorNumberFormat.format(this.options.convertLengthResidualToView(value));
            }
            case LENGTH_UNCERTAINTY: {
                return this.editorNumberFormat.format(this.options.convertLengthUncertaintyToView(value));
            }
            case SCALE: {
                return this.editorNumberFormat.format(this.options.convertScaleToView(value));
            }
            case SCALE_RESIDUAL: {
                return this.editorNumberFormat.format(this.options.convertScaleResidualToView(value));
            }
            case SCALE_UNCERTAINTY: {
                return this.editorNumberFormat.format(this.options.convertScaleUncertaintyToView(value));
            }
            case DOUBLE: 
            case STATISTIC: {
                return this.editorNumberFormat.format(value);
            }
            case VECTOR: {
                return this.editorNumberFormat.format(this.options.convertVectorToView(value));
            }
            case VECTOR_RESIDUAL: {
                return this.editorNumberFormat.format(this.options.convertVectorResidualToView(value));
            }
            case VECTOR_UNCERTAINTY: {
                return this.editorNumberFormat.format(this.options.convertVectorUncertaintyToView(value));
            }
            case TEMPERATURE: {
                return this.editorNumberFormat.format(this.options.convertTemperatureToView(value));
            }
            case PRESSURE: {
                return this.editorNumberFormat.format(this.options.convertPressureToView(value));
            }
            case PERCENTAGE: {
                return this.editorNumberFormat.format(this.options.convertPercentToView(value));
            }
        }
        System.err.println(((Object)((Object)this)).getClass().getSimpleName() + " : Unsupported cell value type " + String.valueOf((Object)this.cellValueType));
        return String.valueOf(value);
    }

    public String toString(Double value) {
        if (value == null) {
            return "";
        }
        switch (this.cellValueType) {
            case ANGLE: {
                return this.options.toAngleFormat(value, this.displayUnit);
            }
            case ANGLE_RESIDUAL: {
                return this.options.toAngleResidualFormat(value, this.displayUnit);
            }
            case ANGLE_UNCERTAINTY: {
                return this.options.toAngleUncertaintyFormat(value, this.displayUnit);
            }
            case LENGTH: {
                return this.options.toLengthFormat(value, this.displayUnit);
            }
            case LENGTH_RESIDUAL: {
                return this.options.toLengthResidualFormat(value, this.displayUnit);
            }
            case LENGTH_UNCERTAINTY: {
                return this.options.toLengthUncertaintyFormat(value, this.displayUnit);
            }
            case SCALE: {
                return this.options.toScaleFormat(value, this.displayUnit);
            }
            case SCALE_RESIDUAL: {
                return this.options.toScaleResidualFormat(value, this.displayUnit);
            }
            case SCALE_UNCERTAINTY: {
                return this.options.toScaleUncertaintyFormat(value, this.displayUnit);
            }
            case STATISTIC: {
                return this.options.toStatisticFormat(value);
            }
            case DOUBLE: {
                return this.options.toDoubleFormat(value);
            }
            case VECTOR: {
                return this.options.toVectorFormat(value, this.displayUnit);
            }
            case VECTOR_RESIDUAL: {
                return this.options.toVectorResidualFormat(value, this.displayUnit);
            }
            case VECTOR_UNCERTAINTY: {
                return this.options.toVectorUncertaintyFormat(value, this.displayUnit);
            }
            case TEMPERATURE: {
                return this.options.toTemperatureFormat(value, this.displayUnit);
            }
            case PRESSURE: {
                return this.options.toPressureFormat(value, this.displayUnit);
            }
            case PERCENTAGE: {
                return this.options.toPercentFormat(value, this.displayUnit);
            }
        }
        System.err.println(((Object)((Object)this)).getClass().getSimpleName() + " : Unsupported cell value type " + String.valueOf((Object)this.cellValueType));
        return String.valueOf(value);
    }

    public Double fromString(String string) {
        if (string != null && !string.trim().isEmpty()) {
            try {
                string = string.replaceAll(",", ".");
                double value = this.options.getFormatterOptions().get((Object)this.cellValueType).parse(string.trim()).doubleValue();
                switch (this.cellValueType) {
                    case ANGLE: {
                        return this.options.convertAngleToModel(value);
                    }
                    case ANGLE_RESIDUAL: {
                        return this.options.convertAngleResidualToModel(value);
                    }
                    case ANGLE_UNCERTAINTY: {
                        return this.options.convertAngleUncertaintyToModel(value);
                    }
                    case LENGTH: {
                        return this.options.convertLengthToModel(value);
                    }
                    case LENGTH_RESIDUAL: {
                        return this.options.convertLengthResidualToModel(value);
                    }
                    case LENGTH_UNCERTAINTY: {
                        return this.options.convertLengthUncertaintyToModel(value);
                    }
                    case SCALE: {
                        return this.options.convertScaleToModel(value);
                    }
                    case SCALE_RESIDUAL: {
                        return this.options.convertScaleResidualToModel(value);
                    }
                    case SCALE_UNCERTAINTY: {
                        return this.options.convertScaleUncertaintyToModel(value);
                    }
                    case DOUBLE: 
                    case STATISTIC: {
                        return value;
                    }
                    case VECTOR: {
                        return this.options.convertVectorToModel(value);
                    }
                    case VECTOR_RESIDUAL: {
                        return this.options.convertVectorResidualToModel(value);
                    }
                    case VECTOR_UNCERTAINTY: {
                        return this.options.convertVectorUncertaintyToModel(value);
                    }
                    case TEMPERATURE: {
                        return this.options.convertTemperatureToModel(value);
                    }
                    case PRESSURE: {
                        return this.options.convertPressureToModel(value);
                    }
                    case PERCENTAGE: {
                        return this.options.convertPercentToModel(value);
                    }
                }
                System.err.println(((Object)((Object)this)).getClass().getSimpleName() + " : Unsupported cell value type " + String.valueOf((Object)this.cellValueType));
                return value;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

