/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.ui.table;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.applied_geodesy.ui.table.EditableCellConverter;

public class EditableCell<T, S>
extends TableCell<T, S> {
    private final TextField textField = new TextField();
    private final EditableCellConverter<S> converter;

    public EditableCell(EditableCellConverter<S> converter) {
        this.converter = converter;
        this.converter.setEditableCell(this);
        this.init();
    }

    public EditableCellConverter<S> getEditableCellConverter() {
        return this.converter;
    }

    private void init() {
        this.itemProperty().addListener(new ChangeListener<S>(){

            public void changed(ObservableValue<? extends S> observable, S oldValue, S newValue) {
                EditableCell.this.setText(newValue == null ? null : EditableCell.this.converter.toString(newValue));
            }
        });
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.textField.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                EditableCell.this.commitEdit(EditableCell.this.converter.fromString(EditableCell.this.textField.getText()));
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    EditableCell.this.commitEdit(EditableCell.this.converter.fromString(EditableCell.this.textField.getText()));
                }
            }
        });
        this.textField.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ESCAPE) {
                    EditableCell.this.textField.setText(EditableCell.this.converter.toEditorString(EditableCell.this.getItem()));
                    EditableCell.this.cancelEdit();
                    event.consume();
                } else if (event.getCode() == KeyCode.TAB) {
                    EditableCell.this.commitEdit(EditableCell.this.converter.fromString(EditableCell.this.textField.getText()));
                    TableColumn nextColumn = EditableCell.this.getNextColumn(!event.isShiftDown());
                    TableView table = EditableCell.this.getTableView();
                    if (table != null && nextColumn != null) {
                        table.requestFocus();
                        table.getSelectionModel().select(EditableCell.this.getTableRow().getIndex(), nextColumn);
                        table.edit(EditableCell.this.getTableRow().getIndex(), nextColumn);
                    }
                    event.consume();
                }
            }
        });
    }

    public void startEdit() {
        super.startEdit();
        this.textField.setText(this.converter.toEditorString(this.getItem()));
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.textField.requestFocus();
        this.textField.selectAll();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    public void commitEdit(S item) {
        TableView table;
        if (item != null && this.getItem() != null && !this.isEditing() && !item.equals(this.getItem()) && (table = this.getTableView()) != null) {
            TableColumn column = this.getTableColumn();
            TableColumn.CellEditEvent event = new TableColumn.CellEditEvent(table, new TablePosition(table, this.getIndex(), column), TableColumn.editCommitEvent(), item);
            Event.fireEvent((EventTarget)column, (Event)event);
        }
        super.commitEdit(item);
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    private TableColumn<T, ?> getNextColumn(boolean forward) {
        int currentIndex;
        ArrayList columns = new ArrayList();
        TableView table = this.getTableView();
        for (TableColumn column : table.getColumns()) {
            columns.addAll(this.getLeaves(column));
        }
        if (columns.size() < 2) {
            return null;
        }
        int nextIndex = currentIndex = columns.indexOf(this.getTableColumn());
        if (forward) {
            if (++nextIndex > columns.size() - 1) {
                nextIndex = 0;
            }
        } else if (--nextIndex < 0) {
            nextIndex = columns.size() - 1;
        }
        return (TableColumn)columns.get(nextIndex);
    }

    private List<TableColumn<T, ?>> getLeaves(TableColumn<T, ?> root) {
        ArrayList columns = new ArrayList();
        if (root.getColumns().isEmpty()) {
            if (root.isEditable() && root.isVisible() && !(root.getCellObservableValue(0).getValue() instanceof Boolean)) {
                columns.add(root);
            }
            return columns;
        }
        for (TableColumn column : root.getColumns()) {
            columns.addAll(this.getLeaves(column));
        }
        return columns;
    }
}

