/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.ui.table;

import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterEventType;
import org.applied_geodesy.util.FormatterOptions;
import org.applied_geodesy.util.unit.Unit;

public class ColumnTooltipHeader
implements FormatterChangedListener {
    private ObjectProperty<String> header = new SimpleObjectProperty();
    private ObjectProperty<String> labelText = new SimpleObjectProperty();
    private ObjectProperty<String> unitText = new SimpleObjectProperty();
    private ObjectProperty<String> tooltipText = new SimpleObjectProperty();
    private final CellValueType type;
    private Label label = new Label();
    private Tooltip tooltip = new Tooltip();
    private boolean displayUnit = false;

    public ColumnTooltipHeader(CellValueType type, String label, String tooltip) {
        this(type, label, tooltip, null);
    }

    public ColumnTooltipHeader(CellValueType type, String label, String tooltip, Unit unit) {
        FormatterOptions.getInstance().addFormatterChangedListener(this);
        this.type = type;
        this.displayUnit = unit != null;
        this.header.bind((ObservableValue)Bindings.concat((Object[])new Object[]{this.labelText}).concat(this.unitText));
        this.label.textProperty().bind(this.header);
        this.tooltip.textProperty().bind(this.tooltipText);
        this.labelText.set((Object)label);
        this.unitText.set(this.displayUnit ? " " + unit.toFormattedAbbreviation() : "");
        this.tooltipText.set((Object)tooltip);
    }

    @Override
    public void formatterChanged(FormatterEvent evt) {
        if (this.displayUnit && evt.getEventType() == FormatterEventType.UNIT_CHANGED && this.type == evt.getCellType()) {
            Unit unit = evt.getNewUnit();
            this.unitText.set((Object)(" " + unit.toFormattedAbbreviation()));
        }
    }

    public Label getLabel() {
        return this.label;
    }

    public Tooltip getTooltip() {
        return this.tooltip;
    }
}

