/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.ui.spinner;

import java.text.NumberFormat;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterOptions;

public class DoubleSpinner
extends Spinner<Double>
implements FormatterChangedListener {
    private FormatterOptions options = FormatterOptions.getInstance();
    private final CellValueType cellValueType;
    private final double min;
    private final double max;
    private final double amountToStepBy;
    private Double number;
    private NumberFormat editorNumberFormat;
    private static final int EDITOR_ADDITIONAL_DIGITS = 10;
    private SpinnerValueFactory.DoubleSpinnerValueFactory doubleFactory = (SpinnerValueFactory.DoubleSpinnerValueFactory)this.getValueFactory();

    public DoubleSpinner(CellValueType cellValueType, double min, double max, double amountToStepBy) {
        this(cellValueType, min, max, min, amountToStepBy);
    }

    public DoubleSpinner(CellValueType cellValueType, double min, double max, double initialValue, double amountToStepBy) {
        this.options.addFormatterChangedListener(this);
        this.min = min;
        this.max = max;
        this.number = initialValue;
        this.amountToStepBy = amountToStepBy;
        this.cellValueType = cellValueType;
        this.init();
    }

    private void prepareEditorNumberFormat() {
        this.editorNumberFormat = (NumberFormat)this.options.getFormatterOptions().get((Object)this.cellValueType).getFormatter().clone();
        this.editorNumberFormat.setMinimumFractionDigits(this.editorNumberFormat.getMaximumFractionDigits());
        this.editorNumberFormat.setMaximumFractionDigits(this.editorNumberFormat.getMaximumFractionDigits() + 10);
    }

    private TextFormatter<Double> createTextFormatter() {
        StringConverter<Double> converter = new StringConverter<Double>(){

            public Double fromString(String s) {
                if (s == null || s.trim().isEmpty()) {
                    return null;
                }
                try {
                    return DoubleSpinner.this.editorNumberFormat.parse(s.replaceAll(",", ".")).doubleValue();
                }
                catch (Exception nfe) {
                    nfe.printStackTrace();
                    return null;
                }
            }

            public String toString(Double d) {
                return d == null ? "" : DoubleSpinner.this.editorNumberFormat.format(d);
            }
        };
        return new TextFormatter((StringConverter)converter, (Object)((Double)this.doubleFactory.getValue()));
    }

    private void init() {
        this.initDoubleValueFactory();
        this.prepareEditorNumberFormat();
        TextFormatter<Double> formatter = this.createTextFormatter();
        this.doubleFactory.setConverter(formatter.getValueConverter());
        this.setEditable(true);
        this.setValueFactory((SpinnerValueFactory)this.doubleFactory);
        this.getEditor().setTextFormatter(formatter);
        this.getEditor().setAlignment(Pos.BOTTOM_RIGHT);
        this.doubleFactory.valueProperty().addListener((ChangeListener)new ChangeListener<Double>(){

            public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
                if (newValue == null) {
                    DoubleSpinner.this.doubleFactory.setValue((Object)oldValue);
                    return;
                }
                switch (DoubleSpinner.this.cellValueType) {
                    case ANGLE: {
                        DoubleSpinner.this.number = DoubleSpinner.this.options.convertAngleToModel(newValue);
                        break;
                    }
                    case ANGLE_RESIDUAL: {
                        DoubleSpinner.this.number = DoubleSpinner.this.options.convertAngleResidualToModel(newValue);
                        break;
                    }
                    case ANGLE_UNCERTAINTY: {
                        DoubleSpinner.this.number = DoubleSpinner.this.options.convertAngleUncertaintyToModel(newValue);
                        break;
                    }
                    case LENGTH: {
                        DoubleSpinner.this.number = DoubleSpinner.this.options.convertLengthToModel(newValue);
                        break;
                    }
                    case LENGTH_RESIDUAL: {
                        DoubleSpinner.this.number = DoubleSpinner.this.options.convertLengthResidualToModel(newValue);
                        break;
                    }
                    case LENGTH_UNCERTAINTY: {
                        DoubleSpinner.this.number = DoubleSpinner.this.options.convertLengthUncertaintyToModel(newValue);
                        break;
                    }
                    case SCALE: {
                        DoubleSpinner.this.number = DoubleSpinner.this.options.convertScaleToModel(newValue);
                        break;
                    }
                    case SCALE_RESIDUAL: {
                        DoubleSpinner.this.number = DoubleSpinner.this.options.convertScaleResidualToModel(newValue);
                        break;
                    }
                    case SCALE_UNCERTAINTY: {
                        DoubleSpinner.this.number = DoubleSpinner.this.options.convertScaleUncertaintyToModel(newValue);
                        break;
                    }
                    case VECTOR: {
                        DoubleSpinner.this.number = DoubleSpinner.this.options.convertVectorToModel(newValue);
                        break;
                    }
                    case VECTOR_RESIDUAL: {
                        DoubleSpinner.this.number = DoubleSpinner.this.options.convertVectorResidualToModel(newValue);
                        break;
                    }
                    case VECTOR_UNCERTAINTY: {
                        DoubleSpinner.this.number = DoubleSpinner.this.options.convertVectorUncertaintyToModel(newValue);
                        break;
                    }
                    case TEMPERATURE: {
                        DoubleSpinner.this.number = DoubleSpinner.this.options.convertTemperatureToModel(newValue);
                        break;
                    }
                    case PRESSURE: {
                        DoubleSpinner.this.number = DoubleSpinner.this.options.convertPressureToModel(newValue);
                        break;
                    }
                    case PERCENTAGE: {
                        DoubleSpinner.this.number = DoubleSpinner.this.options.convertPercentToModel(newValue);
                        break;
                    }
                    case DOUBLE: 
                    case STATISTIC: {
                        DoubleSpinner.this.number = newValue;
                        break;
                    }
                    default: {
                        DoubleSpinner.this.number = newValue;
                    }
                }
            }
        });
    }

    private void initDoubleValueFactory() {
        double vvalue;
        double vmax;
        double vmin;
        double vamountToStepBy = switch (this.cellValueType) {
            case CellValueType.ANGLE -> {
                vmin = this.options.convertAngleToView(this.min);
                vmax = this.options.convertAngleToView(this.max);
                vvalue = this.options.convertAngleToView(this.number);
                yield this.options.convertAngleToView(this.amountToStepBy);
            }
            case CellValueType.ANGLE_RESIDUAL -> {
                vmin = this.options.convertAngleResidualToView(this.min);
                vmax = this.options.convertAngleResidualToView(this.max);
                vvalue = this.options.convertAngleResidualToView(this.number);
                yield this.options.convertAngleResidualToView(this.amountToStepBy);
            }
            case CellValueType.ANGLE_UNCERTAINTY -> {
                vmin = this.options.convertAngleUncertaintyToView(this.min);
                vmax = this.options.convertAngleUncertaintyToView(this.max);
                vvalue = this.options.convertAngleUncertaintyToView(this.number);
                yield this.options.convertAngleUncertaintyToView(this.amountToStepBy);
            }
            case CellValueType.LENGTH -> {
                vmin = this.options.convertLengthToView(this.min);
                vmax = this.options.convertLengthToView(this.max);
                vvalue = this.options.convertLengthToView(this.number);
                yield this.options.convertLengthToView(this.amountToStepBy);
            }
            case CellValueType.LENGTH_RESIDUAL -> {
                vmin = this.options.convertLengthResidualToView(this.min);
                vmax = this.options.convertLengthResidualToView(this.max);
                vvalue = this.options.convertLengthResidualToView(this.number);
                yield this.options.convertLengthResidualToView(this.amountToStepBy);
            }
            case CellValueType.LENGTH_UNCERTAINTY -> {
                vmin = this.options.convertLengthUncertaintyToView(this.min);
                vmax = this.options.convertLengthUncertaintyToView(this.max);
                vvalue = this.options.convertLengthUncertaintyToView(this.number);
                yield this.options.convertLengthUncertaintyToView(this.amountToStepBy);
            }
            case CellValueType.SCALE -> {
                vmin = this.options.convertScaleToView(this.min);
                vmax = this.options.convertScaleToView(this.max);
                vvalue = this.options.convertScaleToView(this.number);
                yield this.options.convertScaleToView(this.amountToStepBy);
            }
            case CellValueType.SCALE_RESIDUAL -> {
                vmin = this.options.convertScaleResidualToView(this.min);
                vmax = this.options.convertScaleResidualToView(this.max);
                vvalue = this.options.convertScaleResidualToView(this.number);
                yield this.options.convertScaleResidualToView(this.amountToStepBy);
            }
            case CellValueType.SCALE_UNCERTAINTY -> {
                vmin = this.options.convertScaleUncertaintyToView(this.min);
                vmax = this.options.convertScaleUncertaintyToView(this.max);
                vvalue = this.options.convertScaleUncertaintyToView(this.number);
                yield this.options.convertScaleUncertaintyToView(this.amountToStepBy);
            }
            case CellValueType.VECTOR -> {
                vmin = this.options.convertVectorToView(this.min);
                vmax = this.options.convertVectorToView(this.max);
                vvalue = this.options.convertVectorToView(this.number);
                yield this.options.convertVectorToView(this.amountToStepBy);
            }
            case CellValueType.VECTOR_RESIDUAL -> {
                vmin = this.options.convertVectorResidualToView(this.min);
                vmax = this.options.convertVectorResidualToView(this.max);
                vvalue = this.options.convertVectorResidualToView(this.number);
                yield this.options.convertVectorResidualToView(this.amountToStepBy);
            }
            case CellValueType.VECTOR_UNCERTAINTY -> {
                vmin = this.options.convertVectorUncertaintyToView(this.min);
                vmax = this.options.convertVectorUncertaintyToView(this.max);
                vvalue = this.options.convertVectorUncertaintyToView(this.number);
                yield this.options.convertVectorUncertaintyToView(this.amountToStepBy);
            }
            case CellValueType.TEMPERATURE -> {
                vmin = this.options.convertTemperatureToView(this.min);
                vmax = this.options.convertTemperatureToView(this.max);
                vvalue = this.options.convertTemperatureToView(this.number);
                yield this.options.convertTemperatureToView(this.amountToStepBy);
            }
            case CellValueType.PRESSURE -> {
                vmin = this.options.convertPressureToView(this.min);
                vmax = this.options.convertPressureToView(this.max);
                vvalue = this.options.convertPressureToView(this.number);
                yield this.options.convertPressureToView(this.amountToStepBy);
            }
            case CellValueType.PERCENTAGE -> {
                vmin = this.options.convertPercentToView(this.min);
                vmax = this.options.convertPercentToView(this.max);
                vvalue = this.options.convertPercentToView(this.number);
                yield this.options.convertPercentToView(this.amountToStepBy);
            }
            case CellValueType.DOUBLE, CellValueType.STATISTIC -> {
                vmin = this.min;
                vmax = this.max;
                vvalue = this.number;
                yield this.amountToStepBy;
            }
            default -> {
                vmin = this.min;
                vmax = this.max;
                vvalue = this.number;
                yield this.amountToStepBy;
            }
        };
        if (this.doubleFactory == null) {
            this.doubleFactory = new SpinnerValueFactory.DoubleSpinnerValueFactory(vmin, vmax, vvalue, vamountToStepBy);
        } else {
            this.doubleFactory.setMin(vmin);
            this.doubleFactory.setMax(vmax);
            this.doubleFactory.setAmountToStepBy(vamountToStepBy);
            this.doubleFactory.setValue((Object)vvalue);
        }
    }

    public Number getNumber() {
        return this.number;
    }

    @Override
    public void formatterChanged(FormatterEvent evt) {
        this.initDoubleValueFactory();
        this.prepareEditorNumberFormat();
        TextFormatter<Double> formatter = this.createTextFormatter();
        this.getEditor().setTextFormatter(formatter);
        this.doubleFactory.setConverter(formatter.getValueConverter());
    }
}

