/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.ui.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.applied_geodesy.jag3d.DefaultApplicationProperty;

public class DefaultFileChooser {
    private static File lastSelectedDirectory = DefaultApplicationProperty.getDefaultWorkspacePath();
    private static FileChooser.ExtensionFilter lastSelectedExtensionFilter = null;
    private static String lastSelectedFileName = "";
    private static final FileChooser fileChooser = new FileChooser();

    private DefaultFileChooser() {
    }

    private static void prepareFileChooser(String title, String initialFileName, FileChooser.ExtensionFilter ... extensionFilters) {
        if (lastSelectedDirectory == null && System.getProperty("user.home", null) != null) {
            lastSelectedDirectory = new File(System.getProperty("user.home"));
        }
        fileChooser.setInitialDirectory(lastSelectedDirectory != null && Files.exists(lastSelectedDirectory.toPath(), new LinkOption[0]) ? lastSelectedDirectory : null);
        fileChooser.setInitialFileName(initialFileName == null ? lastSelectedFileName : initialFileName);
        fileChooser.setTitle(title);
        if (extensionFilters != null && extensionFilters.length > 0) {
            boolean containsFilter = false;
            FileChooser.ExtensionFilter[] extensionFilterArray = extensionFilters;
            int n = extensionFilters.length;
            int n2 = 0;
            while (n2 < n) {
                FileChooser.ExtensionFilter filter = extensionFilterArray[n2];
                if (DefaultFileChooser.equalExtensionFilters(lastSelectedExtensionFilter, filter)) {
                    DefaultFileChooser.setLastSelectedExtensionFilter(filter);
                    containsFilter = true;
                    break;
                }
                ++n2;
            }
            fileChooser.getExtensionFilters().setAll((Object[])extensionFilters);
            if (!containsFilter || lastSelectedExtensionFilter == null) {
                lastSelectedExtensionFilter = extensionFilters[0];
            }
            fileChooser.setSelectedExtensionFilter(lastSelectedExtensionFilter);
        } else {
            fileChooser.getExtensionFilters().clear();
        }
    }

    private static boolean equalExtensionFilters(FileChooser.ExtensionFilter filter1, FileChooser.ExtensionFilter filter2) {
        if (filter1 == null || filter2 == null || filter1.getExtensions().size() != filter2.getExtensions().size() || !filter1.getDescription().equals(filter2.getDescription())) {
            return false;
        }
        List extensions = filter1.getExtensions();
        for (String extension : extensions) {
            if (filter2.getExtensions().contains(extension)) continue;
            return false;
        }
        return true;
    }

    public static File showOpenDialog(Window window, String title, String initialFileName, FileChooser.ExtensionFilter ... extensionFilters) {
        DefaultFileChooser.prepareFileChooser(title, initialFileName, extensionFilters);
        File file = fileChooser.showOpenDialog(window);
        DefaultFileChooser.setLastSelectedDirectory(file);
        DefaultFileChooser.setLastSelectedExtensionFilter(fileChooser.getSelectedExtensionFilter());
        return file;
    }

    public static List<File> showOpenMultipleDialog(Window window, String title, String initialFileName, FileChooser.ExtensionFilter ... extensionFilters) {
        DefaultFileChooser.prepareFileChooser(title, initialFileName, extensionFilters);
        List files = fileChooser.showOpenMultipleDialog(window);
        if (files != null && !files.isEmpty() && files.get(0) != null) {
            DefaultFileChooser.setLastSelectedDirectory((File)files.get(0));
            DefaultFileChooser.setLastSelectedExtensionFilter(fileChooser.getSelectedExtensionFilter());
        }
        return files;
    }

    public static File showSaveDialog(Window window, String title, String initialFileName, FileChooser.ExtensionFilter ... extensionFilters) {
        DefaultFileChooser.prepareFileChooser(title, initialFileName, extensionFilters);
        File file = fileChooser.showSaveDialog(window);
        FileChooser.ExtensionFilter extensionFilter = fileChooser.getSelectedExtensionFilter();
        if (file != null && file.getParentFile() != null) {
            DefaultFileChooser.setLastSelectedDirectory(file.getParentFile());
            DefaultFileChooser.setLastSelectedExtensionFilter(extensionFilter);
        }
        if (file != null && extensionFilter != null) {
            boolean hasExtension = false;
            List extensions = extensionFilter.getExtensions();
            if (extensions != null && !extensions.isEmpty()) {
                for (String extension : extensions) {
                    if (!extension.endsWith("*.*") && !file.getName().toLowerCase().endsWith(extension.toLowerCase().substring(1))) continue;
                    hasExtension = true;
                    break;
                }
                if (!hasExtension) {
                    file = new File(file.getAbsolutePath() + ((String)extensions.get(0)).substring(1));
                }
            }
        }
        return file;
    }

    public static FileChooser.ExtensionFilter getSelectedExtensionFilter() {
        return fileChooser.getSelectedExtensionFilter();
    }

    public static void setLastSelectedExtensionFilter(FileChooser.ExtensionFilter extensionFilter) {
        if (extensionFilter == null) {
            return;
        }
        lastSelectedExtensionFilter = extensionFilter;
    }

    public static void setLastSelectedDirectory(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            lastSelectedDirectory = file;
        } else if (file.isFile() && file.getParentFile() != null) {
            lastSelectedDirectory = file.getParentFile();
            DefaultFileChooser.setLastSelectedFileName(file);
        }
    }

    public static void setLastSelectedFileName(File file) {
        if (file == null) {
            return;
        }
        lastSelectedFileName = file.getName().replaceFirst(".[^.]+$", "");
    }
}

