/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.ui.dialog;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Window;

public class OptionDialog {
    private static Window window;

    private OptionDialog() {
    }

    public static void setOwner(Window owner) {
        window = owner;
    }

    private static Optional<ButtonType> showDialog(Alert.AlertType type, String title, String header, String message) {
        Alert alert = new Alert(type);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(message);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner(window);
        alert.setResizable(true);
        alert.getDialogPane().setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        return alert.showAndWait();
    }

    public static Optional<ButtonType> showErrorDialog(String title, String header, String message) {
        return OptionDialog.showDialog(Alert.AlertType.ERROR, title, header, message);
    }

    public static Optional<ButtonType> showWarningDialog(String title, String header, String message) {
        return OptionDialog.showDialog(Alert.AlertType.WARNING, title, header, message);
    }

    public static Optional<ButtonType> showInformationDialog(String title, String header, String message) {
        return OptionDialog.showDialog(Alert.AlertType.INFORMATION, title, header, message);
    }

    public static Optional<ButtonType> showConfirmationDialog(String title, String header, String message) {
        return OptionDialog.showDialog(Alert.AlertType.CONFIRMATION, title, header, message);
    }

    public static Optional<ButtonType> showContentDialog(Alert.AlertType type, String title, String header, String message, Node node) {
        Alert alert = new Alert(type);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(message);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner(window);
        GridPane.setVgrow((Node)node, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)node, (Priority)Priority.ALWAYS);
        GridPane content = new GridPane();
        content.setMaxWidth(Double.MAX_VALUE);
        int row = 0;
        if (message != null) {
            Label label = new Label(message);
            content.add((Node)label, 0, ++row);
        }
        content.add(node, 0, ++row);
        alert.getDialogPane().setContent((Node)content);
        alert.getDialogPane().setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        return alert.showAndWait();
    }

    public static Optional<ButtonType> showThrowableDialog(String title, String header, String message, Throwable throwable) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(message);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner(window);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String throwableText = stringWriter.toString();
        Label label = new Label("Stacktrace:");
        TextArea textArea = new TextArea(throwableText);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)label, 0, 0);
        expContent.add((Node)textArea, 0, 1);
        alert.getDialogPane().setExpandableContent((Node)expContent);
        alert.getDialogPane().setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        return alert.showAndWait();
    }
}

