/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.transformation.datum;

public class PrincipalPoint {
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private double latitude = 0.0;
    private double longitude = 0.0;
    private double height = 0.0;
    private double[][] R = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};

    public PrincipalPoint() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public PrincipalPoint(double x, double y, double z, double latitude, double longitude, double height) {
        this.setCoordinates(x, y, z, latitude, longitude, height);
    }

    public void setCoordinates(double x, double y, double z, double latitude, double longitude, double height) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.latitude = latitude;
        this.longitude = longitude;
        this.height = height;
        double sLatitude = Math.sin(this.latitude);
        double cLatitude = Math.cos(this.latitude);
        double sLongitude = Math.sin(this.longitude);
        double cLongitude = Math.cos(this.longitude);
        this.R = new double[][]{{-sLongitude, cLongitude, 0.0}, {-sLatitude * cLongitude, -sLatitude * sLongitude, cLatitude}, {cLatitude * cLongitude, cLatitude * sLongitude, sLatitude}};
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getHeight() {
        return this.height;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double[][] getRotationSequenceXYZtoENU() {
        return this.R;
    }
}

