/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.transformation.datum;

import org.applied_geodesy.transformation.datum.SecondEllipsoidParameterType;

public class Ellipsoid {
    private final double majorAxis;
    private final double minorAxis;
    private final double inverseFlattening;
    private final double flattening;
    private double firstSquaredEccentricity;
    private double secondSquaredEccentricity;
    private boolean sphereModel = Boolean.FALSE;
    public static final Ellipsoid SPHERE = Ellipsoid.createEllipsoidFromMinorAxis(6371007.0, 6371007.0);
    public static final Ellipsoid WGS84 = Ellipsoid.createEllipsoidFromSquaredEccentricity(6378137.0, 0.00669437999013);
    public static final Ellipsoid GRS80 = Ellipsoid.createEllipsoidFromSquaredEccentricity(6378137.0, 0.0066943800229);
    public static final Ellipsoid BESSEL1941 = Ellipsoid.createEllipsoidFromMinorAxis(Math.exp(6.8046434637 * Math.log(10.0)), Math.exp(6.8031892839 * Math.log(10.0)));
    public static final Ellipsoid KRASSOWSKI = Ellipsoid.createEllipsoidFromInverseFlattening(6378245.0, 298.3);
    public static final Ellipsoid HAYFORD = Ellipsoid.createEllipsoidFromInverseFlattening(6378388.0, 297.0);

    private Ellipsoid(double majorAxis, double secondEllipsoidParameterValue, SecondEllipsoidParameterType parameterType) {
        this.majorAxis = majorAxis;
        switch (parameterType) {
            case SQUARED_ECCENTRICITY: {
                this.firstSquaredEccentricity = secondEllipsoidParameterValue;
                this.sphereModel = this.firstSquaredEccentricity == 0.0;
                this.minorAxis = this.sphereModel ? this.majorAxis : this.majorAxis * Math.sqrt(1.0 - this.firstSquaredEccentricity);
                this.flattening = this.sphereModel ? 0.0 : 1.0 - Math.sqrt(1.0 - this.firstSquaredEccentricity);
                this.inverseFlattening = this.sphereModel ? Double.POSITIVE_INFINITY : 1.0 / (1.0 - Math.sqrt(1.0 - this.firstSquaredEccentricity));
                this.secondSquaredEccentricity = this.sphereModel ? 0.0 : this.firstSquaredEccentricity / (1.0 - this.firstSquaredEccentricity);
                break;
            }
            case INVERSE_FLATTENING: {
                this.inverseFlattening = secondEllipsoidParameterValue;
                this.sphereModel = Double.POSITIVE_INFINITY == this.inverseFlattening;
                this.flattening = this.sphereModel ? 0.0 : 1.0 / this.inverseFlattening;
                this.minorAxis = this.sphereModel ? this.majorAxis : this.majorAxis - this.majorAxis / this.inverseFlattening;
                this.firstSquaredEccentricity = this.sphereModel ? 0.0 : (2.0 - 1.0 / this.inverseFlattening) / this.inverseFlattening;
                this.secondSquaredEccentricity = this.sphereModel ? 0.0 : this.flattening * (2.0 - this.flattening) / Math.pow(1.0 - this.flattening, 2.0);
                break;
            }
            default: {
                this.minorAxis = secondEllipsoidParameterValue;
                this.sphereModel = this.minorAxis == this.majorAxis;
                this.flattening = this.sphereModel ? 0.0 : 1.0 - this.minorAxis / this.majorAxis;
                this.inverseFlattening = this.sphereModel ? Double.POSITIVE_INFINITY : this.majorAxis / (this.majorAxis - this.minorAxis);
                this.firstSquaredEccentricity = this.sphereModel ? 0.0 : 1.0 - this.minorAxis * this.minorAxis / (this.majorAxis * this.majorAxis);
                this.secondSquaredEccentricity = this.sphereModel ? 0.0 : (this.majorAxis * this.majorAxis - this.minorAxis * this.minorAxis) / (this.minorAxis * this.minorAxis);
            }
        }
    }

    public boolean isSphereModel() {
        return this.sphereModel;
    }

    public static Ellipsoid createEllipsoidFromMinorAxis(double majorAxis, double minorAxis) {
        return new Ellipsoid(majorAxis, minorAxis, SecondEllipsoidParameterType.MINOR_AXIS);
    }

    public static Ellipsoid createEllipsoidFromInverseFlattening(double majorAxis, double inverseFlattening) {
        return new Ellipsoid(majorAxis, inverseFlattening, SecondEllipsoidParameterType.INVERSE_FLATTENING);
    }

    public static Ellipsoid createEllipsoidFromSquaredEccentricity(double majorAxis, double eccentricity) {
        return new Ellipsoid(majorAxis, eccentricity, SecondEllipsoidParameterType.SQUARED_ECCENTRICITY);
    }

    public double getRadiusOfConformalSphere(double latitude) {
        if (this.isSphereModel()) {
            return this.majorAxis;
        }
        double sin = Math.sin(latitude);
        double e2 = this.getFirstSquaredEccentricity();
        return this.majorAxis * Math.sqrt(1.0 - e2) / (1.0 - e2 * sin * sin);
    }

    public double getFirstSquaredEccentricity() {
        return this.firstSquaredEccentricity;
    }

    public double getSecondSquaredEccentricity() {
        return this.secondSquaredEccentricity;
    }

    public double getFlattening() {
        return this.flattening;
    }

    public double getInverseFlattening() {
        return this.inverseFlattening;
    }

    public final double getMajorAxis() {
        return this.majorAxis;
    }

    public final double getMinorAxis() {
        return this.minorAxis;
    }

    public String toString() {
        return "Ellipsoid: [" + this.majorAxis + ", " + this.minorAxis + "]";
    }
}

